/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.network.client.socket;

import it.polimi.ingsw.galaxytrucker.network.client.Client;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessage;
import it.polimi.ingsw.galaxytrucker.observer.Observable;
import it.polimi.ingsw.galaxytrucker.observer.Observer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ClientSocket
implements Client,
Observable {
    private Socket socket;
    private ObjectOutputStream outputStream;
    private ObjectInputStream inputStream;
    private ExecutorService readExecutionQueue;
    String address;
    int port;
    private final ExecutorService taskQueue;
    private final ArrayList<Observer> observers = new ArrayList();
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public ClientSocket(String address, Integer port) throws IOException {
        this.port = port;
        this.address = address;
        this.taskQueue = Executors.newSingleThreadExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(NetworkMessage message) throws IOException {
        ObjectOutputStream objectOutputStream = this.outputStream;
        synchronized (objectOutputStream) {
            this.outputStream.writeObject(message);
            this.outputStream.flush();
            this.outputStream.reset();
        }
    }

    public void receiveMessage() {
        this.readExecutionQueue.execute(() -> {
            while (!this.readExecutionQueue.isShutdown()) {
                NetworkMessage message = null;
                try {
                    message = (NetworkMessage)this.inputStream.readObject();
                }
                catch (IOException | ClassNotFoundException e) {
                    this.readExecutionQueue.shutdownNow();
                }
                NetworkMessage finalMessage = message;
                this.executor.submit(() -> {
                    try {
                        this.notifyObservers(finalMessage);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        });
    }

    public void create(String address, int port) throws IOException {
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(address, port));
        this.outputStream = new ObjectOutputStream(this.socket.getOutputStream());
        this.inputStream = new ObjectInputStream(this.socket.getInputStream());
        this.readExecutionQueue = Executors.newSingleThreadExecutor();
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public void notifyObservers(NetworkMessage message) throws IOException, ExecutionException {
        for (Observer observer : this.observers) {
            observer.update(message);
        }
    }
}

