/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.network.client.rmi;

import it.polimi.ingsw.galaxytrucker.controller.ClientController;
import it.polimi.ingsw.galaxytrucker.exceptions.InvalidTilePosition;
import it.polimi.ingsw.galaxytrucker.network.client.rmi.ClientInterfaceRMI;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessage;
import it.polimi.ingsw.galaxytrucker.network.server.RMIClientHandler;
import it.polimi.ingsw.galaxytrucker.network.server.ServerRMIInterface;
import it.polimi.ingsw.galaxytrucker.observer.Observable;
import it.polimi.ingsw.galaxytrucker.observer.Observer;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.PrinterLabels;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.PrinterUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TuiColor;
import it.polimi.ingsw.galaxytrucker.visitors.Network.NetworkMessageNameVisitor;
import it.polimi.ingsw.galaxytrucker.visitors.Network.NetworkMessageVisitor;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;

public class ClientRMI
extends UnicastRemoteObject
implements ClientInterfaceRMI,
Observable {
    private final ArrayList<Observer> observers = new ArrayList();
    Registry registry;
    ServerRMIInterface server;
    ClientInterfaceRMI stub;
    NetworkMessageNameVisitor nmnv = new NetworkMessageNameVisitor();

    public ClientRMI(String address, int port, ClientController controller) throws RemoteException, NotBoundException {
        this.registry = LocateRegistry.getRegistry(address, port);
        this.server = (ServerRMIInterface)this.registry.lookup("GameServer");
        this.stub = this;
        this.addObserver(controller);
        this.server.handleRMIRegistration(this.stub);
    }

    @Override
    public void sendMessage(NetworkMessage message) throws RemoteException {
        if (this.server == null) {
            throw new RemoteException();
        }
        RMIClientHandler handler = this.server.getClientHandler(this);
        NetworkMessageVisitor nmv = new NetworkMessageVisitor(this.server.getControllerHandles(), handler);
        message.accept(nmv);
    }

    @Override
    public void receiveMessage(NetworkMessage message) {
        new Thread(() -> {
            try {
                this.notifyObservers(message);
            }
            catch (InvalidTilePosition | IOException | ExecutionException e) {
                System.err.println(PrinterUtils.getTextWithLabel(PrinterLabels.ServerRMI, TuiColor.BRIGHT_YELLOW, "Couldn't receive message: " + e.getMessage()));
            }
        }).start();
    }

    @Override
    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public void notifyObservers(NetworkMessage message) throws IOException, ExecutionException, InvalidTilePosition {
        for (Observer observer : this.observers) {
            observer.update(message);
        }
    }
}

