/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import it.polimi.ingsw.galaxytrucker.enums.AlienColor;
import it.polimi.ingsw.galaxytrucker.enums.Connector;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AdventureCard;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.CardDeck;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.model.essentials.Slot;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.LifeSupportSystem;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.ShipPrintUtils;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentNameVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import javafx.util.Pair;

public class Util {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CardDeck createLvl1Deck() {
        ObjectMapper mapper = new ObjectMapper();
        String path = "cardsdata.json";
        try (InputStream in = Util.class.getClassLoader().getResourceAsStream(path);){
            if (in == null) {
                System.err.println(path + " not found.");
                return null;
            }
            ArrayList<AdventureCard> cards = new ArrayList<AdventureCard>(mapper.readValue(in, new TypeReference<ArrayList<AdventureCard>>(){}).stream().filter(card -> card.getLevel() == 1).toList());
            CardDeck cardDeck = new CardDeck(cards, true);
            return cardDeck;
        }
        catch (IOException e) {
            System.err.println("Error while reading " + path + " : " + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CardDeck createLvl2Deck() {
        ObjectMapper mapper = new ObjectMapper();
        String path = "cardsdata.json";
        try (InputStream in = Util.class.getClassLoader().getResourceAsStream(path);){
            if (in == null) {
                System.err.println(path + " not found.");
                return null;
            }
            ArrayList<AdventureCard> cards = new ArrayList<AdventureCard>(mapper.readValue(in, new TypeReference<ArrayList<AdventureCard>>(){}).stream().filter(card -> card.getLevel() == 2).toList());
            CardDeck cardDeck = new CardDeck(cards, true);
            return cardDeck;
        }
        catch (IOException e) {
            System.err.println("Error while reading " + path + " : " + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CardDeck createLearningDeck() {
        ObjectMapper mapper = new ObjectMapper();
        String path = "cardsdata.json";
        try (InputStream in = Util.class.getClassLoader().getResourceAsStream(path);){
            if (in == null) {
                System.err.println(path + " not found.");
                return null;
            }
            ArrayList<AdventureCard> cards = new ArrayList<AdventureCard>(mapper.readValue(in, new TypeReference<ArrayList<AdventureCard>>(){}).stream().filter(AdventureCard::isLearningFlight).toList());
            CardDeck cardDeck = new CardDeck(cards, true);
            return cardDeck;
        }
        catch (IOException e) {
            System.err.println("Error while reading " + path + " : " + e.getMessage());
        }
        return null;
    }

    public static CardDeck createTestDeck() {
        ObjectMapper mapper = new ObjectMapper();
        String path = "cardsdata.json";
        ArrayList list = null;
        try (InputStream in = Util.class.getClassLoader().getResourceAsStream(path);){
            if (in == null) {
                System.err.println(path + " not found.");
            } else {
                list = new ArrayList(mapper.readValue(in, new TypeReference<ArrayList<AdventureCard>>(){}));
            }
        }
        catch (IOException e) {
            System.err.println("Error while reading " + path + " : " + e.getMessage());
        }
        ArrayList<AdventureCard> cardsToTest = new ArrayList<AdventureCard>();
        if (list == null) {
            return new CardDeck(cardsToTest, true);
        }
        cardsToTest.add((AdventureCard)list.get(0));
        cardsToTest.add((AdventureCard)list.get(2));
        cardsToTest.add((AdventureCard)list.get(1));
        cardsToTest.add((AdventureCard)list.get(31));
        cardsToTest.add((AdventureCard)list.get(10));
        cardsToTest.add((AdventureCard)list.get(3));
        cardsToTest.add((AdventureCard)list.get(24));
        cardsToTest.add((AdventureCard)list.get(16));
        cardsToTest.add((AdventureCard)list.get(4));
        cardsToTest.add((AdventureCard)list.get(19));
        cardsToTest.add((AdventureCard)list.get(15));
        cardsToTest.add((AdventureCard)list.get(8));
        cardsToTest.add((AdventureCard)list.get(3));
        cardsToTest.add((AdventureCard)list.get(24));
        return new CardDeck(cardsToTest, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<Tile> generateTiles() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String path = "tiledata.json";
        try (InputStream in = Util.class.getClassLoader().getResourceAsStream(path);){
            if (in == null) {
                System.err.println(path + " not found.");
                return new ArrayList<Tile>();
            }
            ArrayList<Tile> arrayList = new ArrayList<Tile>((Collection)mapper.readValue(in, new TypeReference<ArrayList<Tile>>(){}));
            return arrayList;
        }
        catch (IOException e) {
            System.err.println("Error while reading " + path + " : " + e.getMessage());
        }
        return new ArrayList<Tile>();
    }

    public static Boolean EngineWellConnected(Tile T, Ship P, Slot S) {
        boolean wellConnected = true;
        ArrayList<Position> tempIP = P.getInvalidPositions();
        Position sud = new Position(S.getPosition().getX(), S.getPosition().getY() + 1);
        if (T.getRotation() == 0) {
            if (!tempIP.contains(sud) && Util.inBoundaries(sud.getX(), sud.getY()).booleanValue() && P.getShipBoard()[sud.getX()][sud.getY()].getTile() != null) {
                wellConnected = false;
            }
        } else {
            wellConnected = false;
        }
        return wellConnected;
    }

    public static Boolean CannonWellConnected(Tile T, Ship P, Slot S) {
        boolean wellConnected = true;
        ArrayList<Position> tempIP = P.getInvalidPositions();
        Position nord = new Position(S.getPosition().getX(), S.getPosition().getY() - 1);
        Position sud = new Position(S.getPosition().getX(), S.getPosition().getY() + 1);
        Position est = new Position(S.getPosition().getX() + 1, S.getPosition().getY());
        Position ovest = new Position(S.getPosition().getX() - 1, S.getPosition().getY());
        switch (T.getRotation()) {
            case 0: {
                if (tempIP.contains(nord) || !Util.inBoundaries(nord.getX(), nord.getY()).booleanValue() || P.getShipBoard()[nord.getX()][nord.getY()].getTile() == null) break;
                wellConnected = false;
                break;
            }
            case 90: {
                if (tempIP.contains(est) || !Util.inBoundaries(est.getX(), est.getY()).booleanValue() || P.getShipBoard()[est.getX()][est.getY()].getTile() == null) break;
                wellConnected = false;
                break;
            }
            case 180: {
                if (tempIP.contains(sud) || !Util.inBoundaries(sud.getX(), sud.getY()).booleanValue() || P.getShipBoard()[sud.getX()][sud.getY()].getTile() == null) break;
                wellConnected = false;
                break;
            }
            case 270: {
                if (tempIP.contains(ovest) || !Util.inBoundaries(ovest.getX(), ovest.getY()).booleanValue() || P.getShipBoard()[ovest.getX()][ovest.getY()].getTile() == null) break;
                wellConnected = false;
            }
        }
        return wellConnected;
    }

    public static boolean CheckLifeSupportSystem(AlienColor color, Tile tile, Ship ship, Slot slot) {
        Position currentPos = slot.getPosition();
        ArrayList<Connector> currentConnectors = tile.getSides();
        ArrayList<Pair<Position, Tile>> connectedTiles = new ArrayList<Pair<Position, Tile>>(ship.getConnectedTiles(currentPos));
        for (Pair<Position, Tile> pair : connectedTiles) {
            LifeSupportSystem lifeSupportSystem;
            Tile connectedTile = pair.getValue();
            Component component = connectedTile.getMyComponent();
            if (component == null || !component.accept(new ComponentNameVisitor()).equals("BrownLifeSupportSystem") && !component.accept(new ComponentNameVisitor()).equals("PurpleLifeSupportSystem") || (lifeSupportSystem = (LifeSupportSystem)component).getColor() != color) continue;
            ArrayList<Connector> supportConnectors = connectedTile.getSides();
            ShipPrintUtils.printShip(ship);
            if (!Util.areTilesConnected(pair.getKey(), supportConnectors, currentPos, currentConnectors)) continue;
            return true;
        }
        return false;
    }

    public static boolean areTilesConnected(Position pos1, List<Connector> conns1, Position pos2, List<Connector> conns2) {
        int dx = pos2.getX() - pos1.getX();
        int dy = pos2.getY() - pos1.getY();
        if (Math.abs(dx) + Math.abs(dy) != 1 || conns1.isEmpty() || conns2.isEmpty()) {
            return false;
        }
        if (dx == 1) {
            boolean result = Util.compatible(conns1.get(1), conns2.get(3)) && conns1.get(1) != Connector.EMPTY && conns2.get(3) != Connector.EMPTY;
            return result;
        }
        if (dx == -1) {
            boolean result = Util.compatible(conns1.get(3), conns2.get(1)) && conns1.get(3) != Connector.EMPTY && conns2.get(1) != Connector.EMPTY;
            return result;
        }
        if (dy == 1) {
            boolean result = Util.compatible(conns1.get(2), conns2.get(0)) && conns1.get(2) != Connector.EMPTY && conns2.get(0) != Connector.EMPTY;
            return result;
        }
        if (dy == -1) {
            boolean result = Util.compatible(conns1.get(0), conns2.get(2)) && conns1.get(0) != Connector.EMPTY && conns2.get(2) != Connector.EMPTY;
            return result;
        }
        return false;
    }

    public static Boolean wellConnectedConnectors(Ship s, Slot mySlot, Tile T) {
        Slot[][] TempShipBoard = s.getShipBoard();
        Boolean wellConnected = true;
        Boolean isAlone = true;
        int myPosX = mySlot.getPosition().getX();
        int myPosY = mySlot.getPosition().getY();
        boolean tileHasEmpty = false;
        for (Connector c : T.getSides()) {
            if (c != Connector.EMPTY) continue;
            tileHasEmpty = true;
            break;
        }
        boolean tileHasConnector = true;
        int numVisited = 0;
        if (myPosY - 1 >= 0 && TempShipBoard[myPosX][myPosY - 1].getTile() != null) {
            Connector cUp = TempShipBoard[myPosX][myPosY - 1].getTile().getSides().get(2);
            wellConnected = Util.compatible(cUp, T.getSides().getFirst());
            if (!wellConnected.booleanValue()) {
                return false;
            }
            if (cUp.equals((Object)Connector.EMPTY)) {
                ++numVisited;
            }
        }
        if (myPosX - 1 >= 0 && TempShipBoard[myPosX - 1][myPosY].getTile() != null) {
            ++numVisited;
            Connector cLeft = TempShipBoard[myPosX - 1][myPosY].getTile().getSides().get(1);
            wellConnected = Util.compatible(cLeft, T.getSides().get(3));
            if (!wellConnected.booleanValue()) {
                return false;
            }
            if (cLeft.equals((Object)Connector.EMPTY)) {
                ++numVisited;
            }
        }
        if (myPosY + 1 < 5 && TempShipBoard[myPosX][myPosY + 1].getTile() != null) {
            ++numVisited;
            Connector cDown = TempShipBoard[myPosX][myPosY + 1].getTile().getSides().get(0);
            wellConnected = Util.compatible(cDown, T.getSides().get(2));
            if (!wellConnected.booleanValue()) {
                return false;
            }
            if (cDown.equals((Object)Connector.EMPTY)) {
                ++numVisited;
            }
        }
        if (myPosX + 1 < 7 && TempShipBoard[myPosX + 1][myPosY].getTile() != null) {
            ++numVisited;
            Connector cRight = TempShipBoard[myPosX + 1][myPosY].getTile().getSides().get(3);
            wellConnected = Util.compatible(cRight, T.getSides().get(1));
            if (!wellConnected.booleanValue()) {
                return false;
            }
            if (cRight.equals((Object)Connector.EMPTY)) {
                ++numVisited;
            }
        }
        if (numVisited == 4) {
            // empty if block
        }
        return true;
    }

    public static Boolean checkNearLFS(Position position, AlienColor color, Ship myShip) {
        return Util.CheckLifeSupportSystem(color, myShip.getTileFromPosition(position), myShip, myShip.getShipBoard()[position.getX()][position.getY()]);
    }

    public static void visitTile(Tile tile, ArrayList<Integer> tilesID, Slot slot, ArrayList<Position> invalidPositions, Queue<Position> newBrokenPos, Ship myShip) {
        ComponentNameVisitor cnv = new ComponentNameVisitor();
        if (tile == null || tilesID.contains(tile.getId())) {
            return;
        }
        if (!tile.getWellConnected().booleanValue()) {
            newBrokenPos.add(slot.getPosition());
            return;
        }
        tilesID.add(tile.getId());
        ArrayList<Position> positions = Util.getAdjacentPositions(slot.getPosition());
        int s = positions.size();
        for (int i = 0; i < s; ++i) {
            int y;
            Position neighborPos = positions.get(i);
            int x = neighborPos.getX();
            if (!Util.inBoundaries(x, y = neighborPos.getY()).booleanValue() || myShip.getShipBoard()[x][y].getTile() == null || !Util.compatible(myShip.getShipBoard()[x][y].getTile().getSides().get((i + 2) % 4), tile.getSides().get(i))) continue;
            Tile tempTile = myShip.getShipBoard()[x][y].getTile();
            if (!Util.areTilesConnected(slot.getPosition(), tile.getSides(), neighborPos, tempTile.getSides())) continue;
            Util.visitTile(tempTile, tilesID, myShip.getShipBoard()[x][y], invalidPositions, newBrokenPos, myShip);
        }
    }

    public static Pair<Boolean, ArrayList<Integer>> checkShipStructure(Ship myShip, Position startingPos) {
        ArrayList<Integer> visitedTilesId = new ArrayList<Integer>();
        visitedTilesId.add(myShip.getTileFromPosition(startingPos).getId());
        Util.checkShipStructureTileVisitor(startingPos, myShip, visitedTilesId);
        ArrayList<Integer> tilesId = new ArrayList<Integer>(Arrays.stream(myShip.getShipBoard()).flatMap(Arrays::stream).map(Slot::getTile).filter(Objects::nonNull).map(Tile::getId).toList());
        Collections.sort(visitedTilesId);
        Collections.sort(tilesId);
        boolean same = visitedTilesId.equals(tilesId);
        return new Pair<Boolean, ArrayList<Integer>>(same, visitedTilesId);
    }

    private static void checkShipStructureTileVisitor(Position startingPos, Ship myShip, ArrayList<Integer> visitedTilesId) {
        ArrayList<Pair<Position, Tile>> connectedTiles = myShip.getConnectedTiles(startingPos);
        Tile myTile = myShip.getTileFromPosition(startingPos);
        ArrayList<Connector> myConnectors = myTile.getSides();
        ArrayList<Pair> realVisitableTiles = new ArrayList<Pair>(connectedTiles.stream().filter(p -> {
            ArrayList<Connector> connectors2 = ((Tile)p.getValue()).getSides();
            return Util.areTilesConnected(startingPos, myConnectors, (Position)p.getKey(), connectors2);
        }).toList());
        if (!realVisitableTiles.isEmpty()) {
            for (Pair connectedTile : realVisitableTiles) {
                if (visitedTilesId.contains(((Tile)connectedTile.getValue()).getId())) continue;
                visitedTilesId.add(((Tile)connectedTile.getValue()).getId());
                Util.checkShipStructureTileVisitor((Position)connectedTile.getKey(), myShip, visitedTilesId);
            }
        }
    }

    public static Boolean inBoundaries(int x, int y) {
        return y >= 0 && y < 5 && x >= 0 && x < 7;
    }

    public static ArrayList<Position> getAdjacentPositions(Position pos) {
        ArrayList<Position> adjacent = new ArrayList<Position>();
        adjacent.add(new Position(pos.getX(), pos.getY() - 1));
        adjacent.add(new Position(pos.getX() + 1, pos.getY()));
        adjacent.add(new Position(pos.getX(), pos.getY() + 1));
        adjacent.add(new Position(pos.getX() - 1, pos.getY()));
        return adjacent;
    }

    public static boolean compatible(Connector a, Connector b) {
        if (a == null || b == null) {
            return false;
        }
        if (a == Connector.EMPTY || b == Connector.EMPTY) {
            return a == Connector.EMPTY && b == Connector.EMPTY;
        }
        if (a == Connector.UNIVERSAL || b == Connector.UNIVERSAL) {
            return true;
        }
        return a == b;
    }
}

