/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.essentials.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentVisitorInterface;
import java.util.ArrayList;

public class GenericCargoHolds
extends Component {
    private int nMaxContainers;
    private Boolean special;
    private ArrayList<Good> Goods;

    @JsonCreator
    public GenericCargoHolds(@JsonProperty(value="special") Boolean special, @JsonProperty(value="nMaxContainers") int nMaxContainers, @JsonProperty(value="goods") ArrayList<Good> Goods) {
        super(false);
        this.special = special;
        this.nMaxContainers = nMaxContainers;
        this.Goods = new ArrayList<Good>(Goods);
    }

    public GenericCargoHolds(Boolean special, int nMaxContainers) {
        super(false);
        this.special = special;
        this.nMaxContainers = nMaxContainers;
        this.Goods = new ArrayList();
    }

    public int getnMaxContainers() {
        return this.nMaxContainers;
    }

    public ArrayList<Good> getGoods() {
        return new ArrayList<Good>(this.Goods);
    }

    public boolean hasGood(Color color) {
        return this.getGoods().stream().anyMatch(g -> g.getColor() == color);
    }

    public void playerLoadGood(Good g) {
        if (this.Goods == null) {
            this.Goods = new ArrayList();
        }
        if (this.Goods.size() >= this.nMaxContainers) {
            System.out.println("Good list contains more than " + this.nMaxContainers);
            return;
        }
        boolean inserted = false;
        for (int i = 0; i < this.Goods.size(); ++i) {
            if (!this.Goods.get(i).getColor().equals((Object)g.getColor())) continue;
            this.Goods.add(i + 1, new Good(g.getColor()));
            inserted = true;
            break;
        }
        if (!inserted) {
            this.Goods.add(new Good(g.getColor()));
        }
    }

    public void removeGood(Good g) {
        if (this.Goods != null) {
            for (int i = 0; i < this.Goods.size(); ++i) {
                if (!this.Goods.get(i).getColor().equals((Object)g.getColor())) continue;
                this.Goods.remove(i);
                break;
            }
        }
    }

    public void removeGood(Color c) {
        if (c != null) {
            for (int i = 0; i < this.Goods.size(); ++i) {
                if (!this.Goods.get(i).getColor().equals((Object)c)) continue;
                this.Goods.remove(i);
                break;
            }
        }
    }

    public boolean isFull() {
        return this.Goods.size() >= this.nMaxContainers;
    }

    public boolean isEmpty() {
        return this.Goods.isEmpty();
    }

    @Override
    public GenericCargoHolds clone() {
        GenericCargoHolds copy = (GenericCargoHolds)super.clone();
        copy.Goods = new ArrayList<Good>(this.Goods);
        return copy;
    }

    @Override
    public <T> T accept(ComponentVisitorInterface<T> visitor) {
        return visitor.visit(this);
    }

    public Boolean isSpecial() {
        return this.special;
    }
}

