/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.essentials.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Engine;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentVisitorInterface;

public class DoubleEngine
extends Engine {
    private Boolean charged;

    @JsonCreator
    public DoubleEngine(@JsonProperty(value="charged") Boolean charged, @JsonProperty(value="enginePower") int enginePower) {
        super(enginePower);
        this.charged = charged;
    }

    @Override
    public int getEnginePower() {
        this.calculatePower();
        return this.enginePower;
    }

    private void calculatePower() {
        if (this.getRotation() == 0) {
            if (this.charged.booleanValue()) {
                this.enginePower = 2;
                this.charged = false;
            } else {
                this.enginePower = 0;
            }
        } else {
            this.enginePower = 0;
        }
    }

    @Override
    public Boolean isCharged() {
        return this.charged;
    }

    public void setCharged(Boolean charged) {
        this.charged = charged;
    }

    @Override
    public DoubleEngine clone() {
        DoubleEngine copy = (DoubleEngine)super.clone();
        copy.charged = this.charged;
        return copy;
    }

    @Override
    public <T> T accept(ComponentVisitorInterface<T> visitor) {
        return visitor.visit(this);
    }
}

