/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model.essentials.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Cannon;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentVisitorInterface;

public class DoubleCannon
extends Cannon {
    private Boolean charged;

    @JsonCreator
    public DoubleCannon(@JsonProperty(value="charged") Boolean charged, @JsonProperty(value="firePower") Float firePower) {
        super(firePower);
        this.charged = charged;
    }

    @Override
    public Float getFirePower() {
        this.calculateFP();
        return this.FirePower;
    }

    private void calculateFP() {
        if (this.getRotation() == 0) {
            if (!this.charged.booleanValue()) {
                this.FirePower = Float.valueOf(1.0f);
            } else {
                this.FirePower = Float.valueOf(2.0f);
                this.charged = false;
            }
        } else if (!this.charged.booleanValue()) {
            this.FirePower = Float.valueOf(0.5f);
        } else {
            this.charged = false;
            this.FirePower = Float.valueOf(1.0f);
        }
    }

    @Override
    public Boolean isCharged() {
        return this.charged;
    }

    public void setCharged(Boolean charged) {
        this.charged = charged;
    }

    @Override
    public DoubleCannon clone() {
        DoubleCannon copy = (DoubleCannon)super.clone();
        copy.charged = this.charged;
        return copy;
    }

    @Override
    public <T> T accept(ComponentVisitorInterface<T> visitor) {
        return visitor.visit(this);
    }
}

