/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model;

import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.enums.PlayerState;
import it.polimi.ingsw.galaxytrucker.model.Ship;

public class Player {
    private final String nickname;
    private int nCredits;
    private Color color;
    private Ship ship;
    private int placement;
    private final Object shipLock = new Object();
    private PlayerState playerState;

    public Player(String nickname, int nCredits, int placement, Boolean learningMatch) {
        this.nickname = nickname;
        this.nCredits = 0;
        this.placement = placement;
        this.ship = new Ship(learningMatch);
    }

    public String getNickName() {
        return this.nickname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ship getShip() {
        Object object = this.shipLock;
        synchronized (object) {
            return this.ship;
        }
    }

    public void addCredits(int credits) {
        this.nCredits += credits;
    }

    public int getNCredits() {
        return this.nCredits;
    }

    public void setNCredits(int nCredits) {
        this.nCredits = nCredits;
    }

    public int getPlacement() {
        return this.placement;
    }

    public void setPlacement(int placement) {
        this.placement = placement;
    }

    public void replaceShip(Ship ship) {
        this.ship = ship;
    }

    public PlayerState getPlayerState() {
        return this.playerState;
    }

    public void setPlayerState(PlayerState playerState) {
        this.playerState = playerState;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

