/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.model;

import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.essentials.FlightBoardMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FlightBoard
implements Serializable {
    private static final long serialVersionUID = 781273817837L;
    private final FlightBoardMap flightBoardMap;
    private final Map<Color, Integer> playerSteps;
    private final Map<Color, Integer> playerPositions;
    private final Boolean learningMatch;

    public FlightBoard(boolean learningMatch) {
        this.learningMatch = learningMatch;
        this.playerSteps = new HashMap<Color, Integer>();
        this.playerPositions = new HashMap<Color, Integer>();
        this.flightBoardMap = new FlightBoardMap(learningMatch);
    }

    public Boolean getLearningMatch() {
        return this.learningMatch;
    }

    public void positionPlayer(Color token, int pos, Player player) {
        int size = this.flightBoardMap.getFlightBoardMapSlots().size();
        int startPos = pos;
        while (this.flightBoardMap.getFlightBoardMapSlots().get(pos).getPlayerToken() != Color.EMPTY) {
            if ((pos = (pos + 1) % size) != startPos) continue;
            throw new IllegalStateException("No available position on board to place token " + String.valueOf((Object)token));
        }
        this.flightBoardMap.getFlightBoardMapSlots().get(pos).setPlayerToken(token);
        this.playerSteps.put(token, pos);
        this.playerPositions.put(token, pos);
        player.setPlacement(pos);
    }

    public void movePlayer(Color token, int steps, Player player) {
        int direction;
        int size = this.flightBoardMap.getFlightBoardMapSlots().size();
        int currentSteps = this.playerSteps.get((Object)token);
        int initialPos = this.playerPositions.get((Object)token);
        int realStepsMoved = 0;
        int attemptedPos = initialPos;
        int n = direction = steps > 0 ? 1 : -1;
        while (realStepsMoved != steps) {
            attemptedPos = ((attemptedPos + direction) % size + size) % size;
            if (this.flightBoardMap.getFlightBoardMapSlots().get(attemptedPos).getPlayerToken() != Color.EMPTY) continue;
            realStepsMoved += direction;
        }
        int finalPos = attemptedPos;
        while (this.flightBoardMap.getFlightBoardMapSlots().get(finalPos).getPlayerToken() != Color.EMPTY) {
            finalPos = ((finalPos + direction) % size + size) % size;
        }
        this.flightBoardMap.getFlightBoardMapSlots().get(initialPos).setPlayerToken(Color.EMPTY);
        this.flightBoardMap.getFlightBoardMapSlots().get(finalPos).setPlayerToken(token);
        this.playerSteps.put(token, currentSteps + realStepsMoved);
        this.playerPositions.put(token, finalPos);
        player.setPlacement(finalPos);
    }

    public ArrayList<Color> getRankedPlayers() {
        return new ArrayList<Color>(this.playerSteps.entrySet().stream().sorted((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue())).map(Map.Entry::getKey).toList());
    }

    public void removePlayer(Color token) {
        if (!this.playerPositions.containsKey((Object)token)) {
            return;
        }
        int pos = this.playerPositions.get((Object)token);
        this.flightBoardMap.getFlightBoardMapSlots().get(pos).setPlayerToken(Color.EMPTY);
        this.playerSteps.remove((Object)token);
        this.playerPositions.remove((Object)token);
    }

    public Color getLeader() {
        return this.getRankedPlayers().getFirst();
    }

    public Boolean isPlayerLapped(Color token) {
        int size = this.flightBoardMap.getFlightBoardMapSlots().size();
        int mySteps = this.playerSteps.get((Object)token);
        int myLoops = mySteps / size;
        for (Map.Entry<Color, Integer> entry : this.playerSteps.entrySet()) {
            if (entry.getKey() == token) continue;
            int otherSteps = entry.getValue();
            int otherLoops = otherSteps / size;
            if (otherSteps <= mySteps || otherLoops <= myLoops) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Integer> getOccupiedPositions() {
        return new ArrayList<Integer>(this.playerPositions.values());
    }

    public FlightBoardMap getFlightBoardMap() {
        return this.flightBoardMap;
    }

    public int getPlayerPosition(Color token) {
        if (!this.playerPositions.containsKey((Object)token)) {
            throw new IllegalArgumentException("Player with token " + String.valueOf((Object)token) + " not found on the board.");
        }
        return this.playerPositions.get((Object)token);
    }

    public int getPlayerSteps(Color token) {
        return this.playerSteps.getOrDefault((Object)token, 0);
    }
}

