/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.fsms;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.CommonEffects;
import java.util.ArrayList;
import java.util.function.Consumer;

public abstract class CardFSM {
    private final ArrayList<Consumer<CardContext>> phases = this.initPhases();
    private Consumer<CardContext> currentPhase;
    private int currentPhaseIndex = 0;

    protected CardFSM() {
        this.phases.add(CommonEffects::end);
        this.currentPhase = this.phases.get(this.currentPhaseIndex);
    }

    public abstract ArrayList<Consumer<CardContext>> initPhases();

    public void execute(CardContext cardContext) {
        if (this.currentPhase != null) {
            this.currentPhase.accept(cardContext);
        } else {
            System.err.println("[CardFSM] No phase to execute.");
        }
    }

    public void previous() {
        this.currentPhaseIndex = this.currentPhaseIndex == 0 ? 0 : this.currentPhaseIndex - 1;
        this.currentPhase = this.phases.get(this.currentPhaseIndex);
    }

    public void next() {
        ++this.currentPhaseIndex;
        if (this.currentPhaseIndex < this.phases.size()) {
            this.currentPhase = this.phases.get(this.currentPhaseIndex);
        }
    }

    public void skipToEndState() {
        this.currentPhaseIndex = this.phases.size() - 1;
        this.currentPhase = this.phases.getLast();
    }

    public void reset() {
        this.currentPhaseIndex = 0;
        this.currentPhase = this.phases.get(this.currentPhaseIndex);
    }
}

