/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.Utils;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Slavers;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyManager;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.CollectRewardsRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.DiscardCrewMembersRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.CollectRewardsResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.DiscardCrewMembersResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.GameMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;

public class SlaversEffect {
    public static void firePowerCheck(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        Slavers slavers = (Slavers)context.getAdventureCard();
        Player player = context.getCurrentPlayer();
        Float playerFirePower = player.getShip().calculateFirePower();
        float slaversFirePower = slavers.getFirePower();
        Utils.resetDoubleCannon(player);
        ShipUpdate shipUpdate = new ShipUpdate(player.getShip(), player.getNickName());
        Utils.broadcast(context, shipUpdate);
        if (slaversFirePower > playerFirePower.floatValue()) {
            GameMessage personalMessage = new GameMessage("The Slavers are going to haunt you!");
            game.getPlayerHandlers().get(player.getNickName()).sendMessage(personalMessage);
            GameMessage info = new GameMessage();
            info.setMessage(player.getNickName() + " has less FirePower than the Slavers!");
            Utils.broadcastExcept(context, info, player);
            Utils.sleepSafe(600L);
            int playerCrewMembersNumber = player.getShip().getnCrew();
            int nCrewToBeDiscarded = Integer.min(playerCrewMembersNumber, slavers.getPenalty());
            DiscardCrewMembersRequest discardCrewMembersRequest = new DiscardCrewMembersRequest(nCrewToBeDiscarded);
            if (nCrewToBeDiscarded != slavers.getPenalty()) {
                Utils.sendGameMessage(context, player, "Dato che non hai abbastanza membri dell'equipaggio, ti preghiamo di svuotare completamente il tuo equipaggio.");
            }
            Utils.sleepSafe(600L);
            context.nextPhase();
            Utils.sendMessage(context, player, discardCrewMembersRequest);
        } else {
            if (slaversFirePower < playerFirePower.floatValue()) {
                GameMessage personalMessage = new GameMessage("You won against the Slavers!");
                game.getPlayerHandlers().get(player.getNickName()).sendMessage(personalMessage);
                GameMessage info = new GameMessage();
                info.setMessage(player.getNickName() + " has defeated the Slavers!");
                Utils.broadcastExcept(context, info, player);
                Utils.sleepSafe(600L);
                CollectRewardsRequest collectRewardsRequest = new CollectRewardsRequest();
                context.nextPhase(2);
                Utils.sendMessage(context, player, collectRewardsRequest);
                return;
            }
            GameMessage personalMessage = new GameMessage("The Slavers are not going to haunt you!");
            GameMessage info = new GameMessage();
            info.setMessage("Il giocatore" + player.getNickName() + " ha pareggiato con gli schiavisti");
            Utils.broadcastExcept(context, info, player);
            Utils.sleepSafe(600L);
            game.getPlayerHandlers().get(player.getNickName()).sendMessage(personalMessage);
            if (context.currentPlayerIsLast()) {
                context.goToEndPhase();
                context.executePhase();
            } else {
                context.previousPhase();
                context.nextPlayer();
                context.executePhase();
            }
        }
    }

    public static void receivedDiscardCrewMembersResponse(CardContext context) {
        Slavers slavers = (Slavers)context.getAdventureCard();
        Player player = context.getCurrentPlayer();
        DiscardCrewMembersResponse discardCrewMembersResponse = (DiscardCrewMembersResponse)context.getIncomingNetworkMessage();
        Utils.discardCrewMembers(context, player, discardCrewMembersResponse, discardCrewMembersResponse.getHousingPositions().size());
        if (context.currentPlayerIsLast()) {
            context.goToEndPhase();
            context.executePhase();
        } else {
            context.previousPhase(2);
            context.nextPlayer();
            context.executePhase();
        }
    }

    public static void receivedRewardsCollectionResponse(CardContext context) {
        CollectRewardsResponse collectRewardsResponse = (CollectRewardsResponse)context.getIncomingNetworkMessage();
        Player player = context.getCurrentPlayer();
        Slavers slavers = (Slavers)context.getAdventureCard();
        if (collectRewardsResponse.doesWantToCollect()) {
            Utils.broadcastExcept(context, new GameMessage("Player " + player.getNickName() + " chose to collect the rewards!"), player);
            Utils.sleepSafe(600L);
            player.addCredits(slavers.getCredits());
            Utils.movePlayer(context, player, -slavers.getDaysLost());
        } else {
            Utils.broadcastExcept(context, new GameMessage("Player " + player.getNickName() + " chose NOT to collect the rewards!"), player);
            Utils.sleepSafe(600L);
        }
        context.goToEndPhase();
        context.executePhase();
    }
}

