/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.Utils;
import it.polimi.ingsw.galaxytrucker.enums.ActivatableComponent;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileSize;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.Projectile;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Pirates;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyManager;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.ActivateComponentRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.AskTrunkRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.CollectRewardsRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.AskTrunkResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.CollectRewardsResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.GameMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentNameVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class PiratesEffect {
    private static final HashMap<LobbyManager, ArrayList<Player>> losersPerGame = new HashMap();
    private static final HashMap<LobbyManager, Integer> projectileIndexes = new HashMap();
    private static final HashMap<LobbyManager, ArrayList<Ship>> trunksPerGame = new HashMap();
    private static final HashMap<LobbyManager, Boolean> rewardTaken = new HashMap();
    private static final HashMap<LobbyManager, Integer> projectileVictimIndexes = new HashMap();
    private static final HashMap<LobbyManager, Integer> currentDiceRoll = new HashMap();
    private static final Random rand = new Random();

    public static void firePowerCheck(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        Pirates pirates = (Pirates)context.getAdventureCard();
        Player player = context.getCurrentPlayer();
        float piratesFirePower = pirates.getFirePower();
        float playerFirePower = player.getShip().calculateFirePower().floatValue();
        Utils.resetDoubleCannon(player);
        ShipUpdate shipUpdate = new ShipUpdate(player.getShip(), player.getNickName());
        Utils.broadcast(context, shipUpdate);
        if (piratesFirePower > playerFirePower) {
            PiratesEffect.handlePiratesWin(context);
            Utils.sleepSafe(600L);
        } else if (piratesFirePower < playerFirePower) {
            PiratesEffect.handlePlayerWin(context);
            Utils.sleepSafe(600L);
            rewardTaken.computeIfAbsent(game, lobbyManager -> false);
            if (!rewardTaken.get(game).booleanValue()) {
                context.nextPhase();
                CollectRewardsRequest collectRewardsRequest = new CollectRewardsRequest();
                Utils.sendMessage(context, context.getCurrentPlayer(), collectRewardsRequest);
                return;
            }
        } else if (piratesFirePower == playerFirePower) {
            PiratesEffect.handleTie(context);
            Utils.sleepSafe(600L);
        }
        if (context.currentPlayerIsLast()) {
            context.nextPhase(2);
        } else {
            context.nextPlayer();
            context.previousPhase();
        }
        context.executePhase();
    }

    private static void handlePlayerWin(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        Pirates pirates = (Pirates)context.getAdventureCard();
        Player player = context.getCurrentPlayer();
        GameMessage personalMessage = new GameMessage("The Pirates are not going to haunt you!");
        game.getPlayerHandlers().get(player.getNickName()).sendMessage(personalMessage);
        GameMessage info = new GameMessage();
        info.setMessage(player.getNickName() + " has defeated the Pirates!");
        Utils.broadcastExcept(context, info, player);
    }

    private static void handlePiratesWin(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        Pirates pirates = (Pirates)context.getAdventureCard();
        Player player = context.getCurrentPlayer();
        losersPerGame.computeIfAbsent(game, lobbyManager -> new ArrayList());
        losersPerGame.get(game).add(player);
        GameMessage personalMessage = new GameMessage("The Pirates are going to haunt you!");
        game.getPlayerHandlers().get(player.getNickName()).sendMessage(personalMessage);
        GameMessage info = new GameMessage();
        info.setMessage(player.getNickName() + " has less FirePower than the Pirates!");
        Utils.broadcastExcept(context, info, player);
    }

    private static void handleTie(CardContext context) {
        Player player = context.getCurrentPlayer();
        Utils.sendGameMessage(context, player, "The Pirates are not going to haunt you!");
        GameMessage info = new GameMessage();
        info.setMessage(player.getNickName() + " ha pareggiato con i Pirati.");
        Utils.broadcastExcept(context, info, player);
    }

    public static void receivedRewardsCollectionResponse(CardContext context) {
        CollectRewardsResponse collectRewardsResponse = (CollectRewardsResponse)context.getIncomingNetworkMessage();
        Player player = context.getCurrentPlayer();
        Pirates pirates = (Pirates)context.getAdventureCard();
        LobbyManager game = context.getCurrentGame();
        if (collectRewardsResponse.doesWantToCollect() && !rewardTaken.get(game).booleanValue()) {
            player.addCredits(pirates.getCredits());
            Utils.movePlayer(context, player, -pirates.getDaysLost());
            rewardTaken.put(game, true);
            Utils.broadcastExcept(context, new GameMessage("Player " + player.getNickName() + " chose to collect the rewards!"), player);
        } else {
            Utils.broadcastExcept(context, new GameMessage("Player " + player.getNickName() + " chose NOT to collect the rewards!"), player);
        }
        if (context.currentPlayerIsLast()) {
            context.nextPhase(1);
        } else {
            context.nextPlayer();
            context.previousPhase(2);
        }
        context.executePhase();
    }

    public static void cannonaitsStart(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        Pirates pirates = (Pirates)context.getAdventureCard();
        ArrayList losers = losersPerGame.getOrDefault(game, null);
        if (losers == null || losers.isEmpty()) {
            Utils.broadcastGameMessage(context, "Nessuno \u00e8 stato sconfitto, nessun attacco dai Pirati.");
            Utils.sleepSafe(600L);
            losersPerGame.remove(game);
            projectileIndexes.remove(game);
            trunksPerGame.remove(game);
            rewardTaken.remove(game);
            projectileVictimIndexes.remove(game);
            PiratesEffect.resetState(game);
            context.goToEndPhase();
            context.executePhase();
            return;
        }
        projectileIndexes.putIfAbsent(game, 0);
        int projectileIndex = projectileIndexes.get(game);
        if (projectileIndex == pirates.getCannonFires().size()) {
            losersPerGame.remove(game);
            projectileIndexes.remove(game);
            trunksPerGame.remove(game);
            rewardTaken.remove(game);
            projectileVictimIndexes.remove(game);
            PiratesEffect.resetState(game);
            context.goToEndPhase();
            context.executePhase();
            return;
        }
        projectileVictimIndexes.putIfAbsent(game, 0);
        int projectileVictimIndex = projectileVictimIndexes.get(game);
        Player player = (Player)losers.get(projectileVictimIndex);
        context.setCurrentPlayer(player);
        Projectile projectile = pirates.getCannonFires().get(projectileIndex);
        if (projectileIndex < pirates.getCannonFires().size()) {
            ActivateComponentRequest activateShieldRequest = new ActivateComponentRequest(ActivatableComponent.Shield);
            context.nextPhase();
            if (projectile.getSize().equals((Object)ProjectileSize.Little) && Utils.playerCanDefendThemselvesWithAShield(player, projectile)) {
                Utils.sendMessage(context, player, activateShieldRequest);
            } else {
                context.executePhase();
            }
        }
    }

    public static void cannonaitsFire(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        Pirates pirates = (Pirates)context.getAdventureCard();
        Player player = context.getCurrentPlayer();
        Ship playerShip = player.getShip();
        int projectileIndex = projectileIndexes.getOrDefault(game, 0);
        int victimIdx = projectileVictimIndexes.getOrDefault(game, 0);
        Projectile projectile = pirates.getCannonFires().get(projectileIndex);
        if (player.equals(losersPerGame.get(game).get(0))) {
            int viewDiceRoll = rand.nextInt(2, 13);
            currentDiceRoll.putIfAbsent(game, 0);
            currentDiceRoll.put(game, viewDiceRoll);
        }
        int diceRoll = Utils.getCorrectedDiceRoll(currentDiceRoll.get(game), projectile.getDirection());
        Utils.broadcastGameMessage(context, player.getNickName() + "  sta per essere colpito da un " + projectile.getType().name() + " " + String.valueOf((Object)projectile.getSize()) + " da " + projectile.getDirection().name() + ", indice " + String.valueOf(currentDiceRoll.get(game)) + "!");
        Utils.sleepSafe(600L);
        if (losersPerGame.get(game).size() == victimIdx + 1) {
            projectileIndexes.put(game, projectileIndex + 1);
            projectileVictimIndexes.put(game, 0);
        } else {
            projectileVictimIndexes.put(game, victimIdx + 1);
        }
        Utils.broadcastShipUpdate(context, player);
        Utils.sleepSafe(600L);
        Tile destroyedTile = game.getGameController().reactToProjectile(player, projectile, diceRoll);
        if (destroyedTile != null) {
            ComponentNameVisitor componentNameVisitor = new ComponentNameVisitor();
            Utils.broadcastGameMessage(context, "Purtroppo, " + player.getNickName() + " \u00e8 stato colpito e ha perso un " + destroyedTile.getMyComponent().accept(componentNameVisitor));
        } else {
            Utils.broadcastGameMessage(context, "Congratulazioni, " + player.getNickName() + " \u00e8 riuscito a schivare l'attacco!");
        }
        Utils.sleepSafe(600L);
        Utils.resetShield(player);
        Utils.broadcastShipUpdate(context, player);
        if (destroyedTile != null) {
            ArrayList<Ship> tronconi = player.getShip().getTronc();
            trunksPerGame.put(game, tronconi);
            if (tronconi.size() > 1) {
                AskTrunkRequest askTrunkRequest = new AskTrunkRequest(tronconi);
                context.nextPhase();
                Utils.sendMessage(context, player, askTrunkRequest);
            } else {
                context.previousPhase();
                context.executePhase();
            }
        } else {
            context.previousPhase();
            context.executePhase();
        }
    }

    public static void cannonaitsTrunks(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        AskTrunkResponse askTrunkResponse = (AskTrunkResponse)context.getIncomingNetworkMessage();
        int indexTrunk = askTrunkResponse.getTrunkIndex();
        Player player = context.getCurrentPlayer();
        ArrayList<Ship> trunks = trunksPerGame.get(game);
        if (trunks != null && indexTrunk >= 0 && indexTrunk < trunks.size()) {
            Ship newShip = trunks.remove(indexTrunk);
            player.replaceShip(newShip);
            Utils.addDestroyedTilesInTrunc(player, trunks);
        }
        Utils.broadcast(context, new ShipUpdate(player.getShip(), player.getNickName()));
        Utils.broadcastGameMessage(context, player.getNickName() + " ha scelto quale parte della nave tenere dopo l'attacco.");
        Utils.sleepSafe(600L);
        context.previousPhase(2);
        context.executePhase();
    }

    private static void resetState(LobbyManager game) {
        losersPerGame.remove(game);
        projectileIndexes.remove(game);
        trunksPerGame.remove(game);
        rewardTaken.remove(game);
        projectileVictimIndexes.remove(game);
        currentDiceRoll.remove(game);
    }
}

