/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.Utils;
import it.polimi.ingsw.galaxytrucker.enums.ActivatableComponent;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.ActivateComponentRequest;

public abstract class CommonEffects {
    public static void sendDoubleCannonsActivationRequest(CardContext context) {
        Player player = context.getCurrentPlayer();
        Utils.broadcastGameMessage(context, "In attesa che il giocatore " + player.getNickName() + "  scelga se attivare il componente.");
        Utils.sleepSafe(600L);
        ActivateComponentRequest activateDoubleCannonsRequest = new ActivateComponentRequest(ActivatableComponent.DoubleCannon);
        context.nextPhase();
        Utils.sendMessage(context, context.getCurrentPlayer(), activateDoubleCannonsRequest);
    }

    public static void sendDoubleEnginesActivationRequest(CardContext context) {
        Player player = context.getCurrentPlayer();
        Utils.broadcastGameMessage(context, "In attesa che il giocatore " + player.getNickName() + "  scelga se attivare il componente.");
        Utils.sleepSafe(600L);
        ActivateComponentRequest activateDoubleEnginesRequest = new ActivateComponentRequest(ActivatableComponent.DoubleEngine);
        context.nextPhase();
        Utils.sendMessage(context, context.getCurrentPlayer(), activateDoubleEnginesRequest);
    }

    public static void end(CardContext context) {
        Utils.broadcastGameMessage(context, "Effetto della carta concluso");
        Utils.sleepSafe(600L);
        context.getCurrentGame().getGameController().handleEndTurn();
    }
}

