/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.effects.Utils;
import it.polimi.ingsw.galaxytrucker.enums.ActivatableComponent;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileSize;
import it.polimi.ingsw.galaxytrucker.model.FlightBoard;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.Projectile;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.CombatZone;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyManager;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.ActivateComponentRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.AskTrunkRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.DiscardCrewMembersRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.AskTrunkResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.DiscardCrewMembersResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.GameMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentNameVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javafx.util.Pair;

public abstract class CombatZoneEffect {
    private static final HashMap<LobbyManager, Integer> projectileIndexes = new HashMap();
    private static final Random rand = new Random();
    private static final HashMap<LobbyManager, ArrayList<Ship>> trunksPerGame = new HashMap();
    private static final HashMap<LobbyManager, Pair<Integer, Player>> minCrewMembersCheckPairs = new HashMap();
    private static final HashMap<LobbyManager, Integer> levelCombatZone = new HashMap();
    private static final HashMap<LobbyManager, Pair<Integer, Player>> minEnginePowerCheckPairs = new HashMap();
    private static final HashMap<LobbyManager, Pair<Float, Player>> minFirePowerCheckPairs = new HashMap();

    public static void checkLevel(CardContext context) {
        CombatZone combatZone = (CombatZone)context.getAdventureCard();
        LobbyManager game = context.getCurrentGame();
        int level = combatZone.getLevel();
        levelCombatZone.putIfAbsent(game, level);
        if (level == 1) {
            context.nextPhase();
            context.executePhase();
        } else if (level == 2) {
            context.nextPhase(6);
            context.executePhase();
        }
    }

    public static void minCrewMembersCheck(CardContext context) {
        CombatZone combatZone = (CombatZone)context.getAdventureCard();
        Player player = context.getCurrentPlayer();
        int playerCrewMembersNumber = player.getShip().getnCrew();
        CombatZoneEffect.combatZoneCompare(context, playerCrewMembersNumber, minCrewMembersCheckPairs);
        Pair pair = CombatZoneEffect.getNumberPlayerPairFromHashMap(context, minCrewMembersCheckPairs);
        Player minCrewMembersPlayer = pair.getValue();
        if (player.getNickName().equals(context.getCurrentRankedPlayers().getFirst().getNickName())) {
            GameMessage gameInfo = new GameMessage(player.getNickName());
            gameInfo.setMessage("Il giocatore con la minore numero del crew deve ricevere una penalit\u00e0");
            Utils.broadcast(context, gameInfo);
            Utils.sleepSafe(600L);
        }
        if (context.getCurrentPlayer() == context.getCurrentRankedPlayers().getLast()) {
            if (combatZone.getLevel() == 1) {
                Utils.broadcastGameMessage(context, minCrewMembersPlayer.getNickName() + " ha il minor numero di membri dell'equipaggio!");
                Utils.sleepSafe(600L);
                Utils.movePlayer(context, minCrewMembersPlayer, -combatZone.getDaysLost());
                context.setCurrentPlayer(context.getCurrentRankedPlayers().getFirst());
                context.nextPhase();
                context.executePhase();
                return;
            }
            Utils.broadcastGameMessage(context, minCrewMembersPlayer.getNickName() + " ha il minor numero di membri dell'equipaggio!");
            Utils.sleepSafe(600L);
            context.setCurrentPlayer(context.getCurrentRankedPlayers().getFirst());
            context.nextPhase(7);
            context.executePhase();
            return;
        }
        context.nextPlayer();
        context.executePhase();
    }

    public static void sendDoubleEnginesActivationRequest(CardContext context) {
        Player player = context.getCurrentPlayer();
        if (player.getNickName().equals(context.getCurrentRankedPlayers().getFirst().getNickName())) {
            GameMessage gameInfo = new GameMessage(player.getNickName());
            gameInfo.setMessage("Il giocatore con la minore potenza del motore deve ricevere una penalit\u00e0");
            Utils.broadcast(context, gameInfo);
            Utils.sleepSafe(600L);
        }
        if (player.getShip().getComponentPositionsFromName("DoubleEngine").stream().anyMatch(p -> player.getShip().getComponentFromPosition((Position)p).isCharged() == false)) {
            ActivateComponentRequest activateDoubleEnginesRequest = new ActivateComponentRequest(ActivatableComponent.DoubleEngine);
            context.nextPhase();
            Utils.sendMessage(context, player, activateDoubleEnginesRequest);
        } else {
            context.nextPhase();
            context.executePhase();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void minEnginePowerCheck(CardContext context) {
        block7: {
            Player player = context.getCurrentPlayer();
            CombatZone combatZone = (CombatZone)context.getAdventureCard();
            LobbyManager game = context.getCurrentGame();
            int playerEnginePower = player.getShip().calculateEnginePower();
            CombatZoneEffect.combatZoneCompare(context, playerEnginePower, minEnginePowerCheckPairs);
            Pair pair = CombatZoneEffect.getNumberPlayerPairFromHashMap(context, minEnginePowerCheckPairs);
            Player minEnginePowerPlayer = pair.getValue();
            if (context.getCurrentPlayer() == context.getCurrentRankedPlayers().getLast()) {
                if (levelCombatZone.get(game) == 1) {
                    Utils.broadcastGameMessage(context, minEnginePowerPlayer.getNickName() + " ha la minor potenza motrice, quindi perde equipaggio!");
                    Utils.sleepSafe(600L);
                    context.nextPhase();
                    break block7;
                } else {
                    String message;
                    Utils.broadcastGameMessage(context, minEnginePowerPlayer.getNickName() + " ha la minor potenza motrice, quindi perde merci!");
                    Utils.sleepSafe(600L);
                    ArrayList<Good> removedGoods = Utils.getAndRemoveMostValuableGoods(context, player, combatZone.getGoodsLost());
                    int goodsCount = removedGoods.size();
                    int batteryToDiscard = combatZone.getGoodsLost() - goodsCount;
                    if (goodsCount == combatZone.getGoodsLost()) {
                        message = "[CombatZone] Ha ha! We'll steal your " + goodsCount + " most valuable goods!";
                    } else if (goodsCount > 0) {
                        Utils.removeBatteries(context, player, batteryToDiscard);
                        message = "[CombatZone] We'll steal your " + goodsCount + " most valuable good(s) and " + batteryToDiscard + " battery(ies), if you have them.";
                    } else {
                        Utils.removeBatteries(context, player, batteryToDiscard);
                        message = "[CombatZone] You don't have any goods, so we'll steal " + batteryToDiscard + " of your batteries! Well, if you have any, poor fella.";
                    }
                    GameMessage personalInfo = new GameMessage(message);
                    game.getPlayerHandlers().get(player.getNickName()).sendMessage(personalInfo);
                    Utils.sleepSafe(600L);
                    context.previousPhase(2);
                    context.setCurrentPlayer(context.getCurrentRankedPlayers().getFirst());
                    context.executePhase();
                    return;
                }
            }
            context.previousPhase();
        }
        context.nextPlayer();
        context.executePhase();
    }

    public static void sendDiscardCrewMembersRequest(CardContext context) {
        CombatZone combatZone = (CombatZone)context.getAdventureCard();
        int playerCrewMembersNumber = context.getCurrentPlayer().getShip().getnCrew();
        int nCrewToBeDiscarded = Integer.min(playerCrewMembersNumber, combatZone.getCrewMembersLost());
        context.nextPhase();
        Pair pair = CombatZoneEffect.getNumberPlayerPairFromHashMap(context, minEnginePowerCheckPairs);
        Player minEnginePowerPlayer = pair.getValue();
        GameMessage minCrewMemberMessage = new GameMessage(" Il giocatore " + minEnginePowerPlayer.getNickName() + " sta scegliendo di scartare gli equipaggi, attendere che completi la selezione!");
        Utils.broadcast(context, minCrewMemberMessage);
        Utils.sleepSafe(600L);
        if (nCrewToBeDiscarded != combatZone.getCrewMembersLost()) {
            Utils.sendGameMessage(context, minEnginePowerPlayer, "Dato che non hai abbastanza membri dell'equipaggio, ti preghiamo di svuotare completamente il tuo equipaggio.");
        }
        Utils.sleepSafe(600L);
        Utils.sendMessage(context, minEnginePowerPlayer, new DiscardCrewMembersRequest(nCrewToBeDiscarded));
    }

    public static void receivedDiscardCrewMembersRequest(CardContext context) {
        Pair pair = CombatZoneEffect.getNumberPlayerPairFromHashMap(context, minEnginePowerCheckPairs);
        Player minEnginePowerPlayer = pair.getValue();
        DiscardCrewMembersResponse discardCrewMembersResponse = (DiscardCrewMembersResponse)context.getIncomingNetworkMessage();
        Utils.discardCrewMembers(context, CombatZoneEffect.getNumberPlayerPairFromHashMap(context, minEnginePowerCheckPairs).getValue(), discardCrewMembersResponse, discardCrewMembersResponse.getHousingPositions().size());
        GameMessage minCrewMemberMessage = new GameMessage(minEnginePowerPlayer.getNickName() + " ha finito di scartare equipaggio, il gioco pu\u00f2 continuare!");
        Utils.broadcast(context, minCrewMemberMessage);
        minEnginePowerCheckPairs.remove(context.getCurrentGame());
        context.setCurrentPlayer(context.getCurrentRankedPlayers().getFirst());
        context.nextPhase();
        context.executePhase();
    }

    public static void sendDoubleCannonsActivationRequest(CardContext context) {
        Player player = context.getCurrentPlayer();
        if (player.getNickName().equals(context.getCurrentRankedPlayers().getFirst().getNickName())) {
            GameMessage gameInfo = new GameMessage(player.getNickName());
            gameInfo.setMessage("Il giocatore con la minore potenza del cannon deve ricevere una penalit\u00e0");
            Utils.broadcast(context, gameInfo);
            Utils.sleepSafe(600L);
        }
        if (player.getShip().getComponentPositionsFromName("DoubleCannon").stream().anyMatch(p -> player.getShip().getComponentFromPosition((Position)p).isCharged() == false)) {
            ActivateComponentRequest activateDoubleCannonsRequest = new ActivateComponentRequest(ActivatableComponent.DoubleCannon);
            context.nextPhase();
            Utils.sendMessage(context, player, activateDoubleCannonsRequest);
        } else {
            context.nextPhase();
            context.executePhase();
        }
    }

    public static void minFirePowerCheck(CardContext context) {
        Player player = context.getCurrentPlayer();
        CombatZone combatZone = (CombatZone)context.getAdventureCard();
        LobbyManager game = context.getCurrentGame();
        float playerFirePower = player.getShip().calculateFirePower().floatValue();
        CombatZoneEffect.combatZoneCompare(context, Float.valueOf(playerFirePower), minFirePowerCheckPairs);
        Pair pair = CombatZoneEffect.getNumberPlayerPairFromHashMap(context, minFirePowerCheckPairs);
        Player minFirePowerPlayer = pair.getValue();
        if (levelCombatZone.get(game) == 1) {
            if (context.getCurrentPlayer() == context.getCurrentRankedPlayers().getLast()) {
                Utils.broadcastGameMessage(context, minFirePowerPlayer.getNickName() + " ha la minor potenza di fuoco, quindi subisce delle cannonate!");
                context.nextPhase();
                context.executePhase();
            } else {
                context.nextPlayer();
                context.previousPhase();
                context.executePhase();
            }
        } else if (context.getCurrentPlayer() == context.getCurrentRankedPlayers().getLast()) {
            FlightBoard flightBoard = game.getRealGame().getFlightBoard();
            int playerStep = flightBoard.getPlayerPosition(minFirePowerPlayer.getColor());
            Utils.movePlayer(context, minFirePowerPlayer, -combatZone.getDaysLost());
            playerStep = flightBoard.getPlayerPosition(minFirePowerPlayer.getColor());
            Utils.broadcastGameMessage(context, "il giocatore" + minFirePowerPlayer.getNickName() + " ha la potenza di fuoco minima, \u00e8 retrocesso di " + combatZone.getDaysLost() + " passi.");
            context.setCurrentPlayer(context.getCurrentRankedPlayers().getFirst());
            context.previousPhase(5);
            context.executePhase();
        } else {
            context.previousPhase();
            context.nextPlayer();
            context.executePhase();
        }
    }

    public static void cannonaitsStart(CardContext context) {
        LobbyManager lobbyManager = context.getCurrentGame();
        CombatZone combatZone = (CombatZone)context.getAdventureCard();
        Player targetPlayer = combatZone.getLevel() == 1 ? CombatZoneEffect.getNumberPlayerPairFromHashMap(context, minFirePowerCheckPairs).getValue() : CombatZoneEffect.getNumberPlayerPairFromHashMap(context, minCrewMembersCheckPairs).getValue();
        context.setCurrentPlayer(targetPlayer);
        projectileIndexes.putIfAbsent(lobbyManager, 0);
        int projectileIndex = projectileIndexes.get(lobbyManager);
        if (projectileIndex == combatZone.getProjectiles().size()) {
            CombatZoneEffect.resetState(lobbyManager);
            context.goToEndPhase();
            context.executePhase();
            return;
        }
        Projectile projectile = combatZone.getProjectiles().get(projectileIndex);
        if (projectileIndex < combatZone.getProjectiles().size()) {
            ActivateComponentRequest activateShieldRequest = new ActivateComponentRequest(ActivatableComponent.Shield);
            context.nextPhase();
            if (projectile.getSize().equals((Object)ProjectileSize.Little) && Utils.playerCanDefendThemselvesWithAShield(targetPlayer, projectile)) {
                Utils.sendMessage(context, targetPlayer, activateShieldRequest);
            } else {
                context.executePhase();
            }
        }
    }

    public static void cannonaitsFire(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        CombatZone combatZone = (CombatZone)context.getAdventureCard();
        Player player = context.getCurrentPlayer();
        Ship playerShip = player.getShip();
        int projectileIndex = projectileIndexes.getOrDefault(game, 0);
        Projectile projectile = combatZone.getProjectiles().get(projectileIndex);
        int viewDiceRoll = rand.nextInt(2, 13);
        int diceRoll = Utils.getCorrectedDiceRoll(viewDiceRoll, projectile.getDirection());
        Utils.broadcastGameMessage(context, player.getNickName() + "  sta per essere colpito da un " + projectile.getType().name() + " " + String.valueOf((Object)projectile.getSize()) + " da " + projectile.getDirection().name() + ", indice " + viewDiceRoll + "!");
        System.out.println("Stai per essere colpito da un " + projectile.getType().name() + " " + String.valueOf((Object)projectile.getSize()) + " da " + projectile.getDirection().name() + ", indice " + viewDiceRoll + "!");
        Utils.sleepSafe(200L);
        projectileIndexes.put(game, projectileIndex + 1);
        Utils.broadcastShipUpdate(context, player);
        Tile removedTile = game.getGameController().reactToProjectile(player, projectile, diceRoll);
        if (removedTile != null) {
            ComponentNameVisitor componentNameVisitor = new ComponentNameVisitor();
            Utils.broadcastGameMessage(context, "Purtroppo, " + player.getNickName() + " \u00e8 stato colpito e ha perso un " + removedTile.getMyComponent().accept(componentNameVisitor));
        } else {
            Utils.broadcastGameMessage(context, "Congratulazioni, " + player.getNickName() + " \u00e8 riuscito a schivare l'attacco!");
        }
        Utils.sleepSafe(600L);
        Utils.resetShield(player);
        Utils.broadcastShipUpdate(context, player);
        if (removedTile != null) {
            ArrayList<Ship> tronconi = player.getShip().getTronc();
            trunksPerGame.put(game, tronconi);
            if (tronconi.size() > 1) {
                AskTrunkRequest askTrunkRequest = new AskTrunkRequest(tronconi);
                context.nextPhase();
                Utils.sendMessage(context, player, askTrunkRequest);
            } else {
                context.previousPhase();
                context.executePhase();
            }
        } else {
            context.previousPhase();
            context.executePhase();
        }
    }

    public static void cannonaitsTrunks(CardContext context) {
        LobbyManager game = context.getCurrentGame();
        AskTrunkResponse askTrunkResponse = (AskTrunkResponse)context.getIncomingNetworkMessage();
        int indexTrunk = askTrunkResponse.getTrunkIndex();
        Player player = context.getCurrentPlayer();
        ArrayList<Ship> trunks = trunksPerGame.get(game);
        if (trunks != null && indexTrunk >= 0 && indexTrunk < trunks.size()) {
            Ship newShip = trunks.remove(indexTrunk);
            player.replaceShip(newShip);
            Utils.addDestroyedTilesInTrunc(player, trunks);
        }
        Utils.broadcast(context, new ShipUpdate(player.getShip(), player.getNickName()));
        context.previousPhase(2);
        context.executePhase();
    }

    private static <T extends Number> Pair<T, Player> getNumberPlayerPairFromHashMap(CardContext context, HashMap<LobbyManager, Pair<T, Player>> map) {
        Pair<Object, Player> integerPlayerPair;
        LobbyManager game = context.getCurrentGame();
        if (map.get(game) != null) {
            integerPlayerPair = map.get(game);
        } else {
            integerPlayerPair = new Pair<Object, Object>(null, null);
            map.put(game, integerPlayerPair);
        }
        return integerPlayerPair;
    }

    private static <T extends Number> void combatZoneCompare(CardContext context, T current, HashMap<LobbyManager, Pair<T, Player>> map) {
        Pair<T, Player> pair = CombatZoneEffect.getNumberPlayerPairFromHashMap(context, map);
        Number min = (Number)pair.getKey();
        Player minPlayer = pair.getValue();
        Player player = context.getCurrentPlayer();
        if (min == null || current.floatValue() < min.floatValue() || min.floatValue() == 0.0f) {
            map.put(context.getCurrentGame(), new Pair<T, Player>(current, player));
        } else if (current.floatValue() == min.floatValue() && (minPlayer == null || player.getPlacement() > minPlayer.getPlacement())) {
            map.put(context.getCurrentGame(), new Pair<T, Player>(current, player));
        }
    }

    private static void resetState(LobbyManager game) {
        projectileIndexes.remove(game);
        trunksPerGame.remove(game);
        minCrewMembersCheckPairs.remove(game);
        levelCombatZone.remove(game);
        minFirePowerCheckPairs.remove(game);
        minEnginePowerCheckPairs.remove(game);
    }
}

