/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement;

import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.fsms.CardFSM;
import it.polimi.ingsw.galaxytrucker.enums.NetworkMessageType;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AdventureCard;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyManager;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessage;
import it.polimi.ingsw.galaxytrucker.network.server.ClientHandler;
import it.polimi.ingsw.galaxytrucker.visitors.adventurecards.AdventureCardFSMVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CardContext {
    private final AdventureCard adventureCard;
    private Player currentPlayer;
    private ClientHandler currentPlayerHandler;
    private ArrayList<Player> currentRankedPlayers;
    private final CardFSM cardFSM;
    private final LobbyManager currentGame;
    private NetworkMessage incomingNetworkMessage;
    private final HashMap<NetworkMessageType, Integer> expectedNumberOfNetworkMessagesPerType;

    public CardContext(LobbyManager currentGame, AdventureCard adventureCard) {
        this.currentGame = currentGame;
        this.adventureCard = adventureCard;
        this.currentRankedPlayers = currentGame.getGameController().getRankedPlayers();
        this.currentPlayer = this.currentRankedPlayers.getFirst();
        this.currentPlayerHandler = currentGame.getPlayerHandlers().get(this.currentPlayer.getNickName());
        this.cardFSM = this.adventureCard.accept(new AdventureCardFSMVisitor());
        this.expectedNumberOfNetworkMessagesPerType = new HashMap<NetworkMessageType, Integer>(Map.of(NetworkMessageType.ShipUpdate, 0, NetworkMessageType.ActivateAdventureCardResponse, 0, NetworkMessageType.ActivateComponentResponse, 0, NetworkMessageType.DiscardCrewMembersResponse, 0, NetworkMessageType.SelectPlanetResponse, 0, NetworkMessageType.AskTrunkResponse, 0, NetworkMessageType.CollectRewardsResponse, 0));
    }

    public LobbyManager getCurrentGame() {
        return this.currentGame;
    }

    public AdventureCard getAdventureCard() {
        return this.adventureCard;
    }

    public ArrayList<Player> getCurrentRankedPlayers() {
        return this.currentRankedPlayers;
    }

    public void setCurrentRankedPlayers(ArrayList<Player> currentRankedPlayers) {
        this.currentRankedPlayers = currentRankedPlayers;
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(Player currentPlayer) {
        this.currentPlayer = currentPlayer;
    }

    public boolean currentPlayerIsLast() {
        return this.getCurrentRankedPlayers().getLast().getNickName().equals(this.currentPlayer.getNickName());
    }

    public void nextPlayer() {
        int i = this.currentRankedPlayers.indexOf(this.currentPlayer);
        this.currentPlayer = i == this.currentRankedPlayers.size() - 1 ? this.currentRankedPlayers.getFirst() : this.currentRankedPlayers.get(i + 1);
        this.currentPlayerHandler = this.currentGame.getPlayerHandlers().get(this.currentPlayer.getNickName());
    }

    public HashMap<NetworkMessageType, Integer> getExpectedNumberOfNetworkMessagesPerType() {
        return this.expectedNumberOfNetworkMessagesPerType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementExpectedNumberOfNetworkMessages(NetworkMessageType type) {
        if (type == null) {
            return;
        }
        HashMap<NetworkMessageType, Integer> hashMap = this.expectedNumberOfNetworkMessagesPerType;
        synchronized (hashMap) {
            int currentValue = this.expectedNumberOfNetworkMessagesPerType.get((Object)type);
            this.expectedNumberOfNetworkMessagesPerType.replace(type, currentValue + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementExpectedNumberOfNetworkMessages(NetworkMessageType type) {
        if (type == null) {
            return;
        }
        HashMap<NetworkMessageType, Integer> hashMap = this.expectedNumberOfNetworkMessagesPerType;
        synchronized (hashMap) {
            int currentValue = this.expectedNumberOfNetworkMessagesPerType.get((Object)type);
            this.expectedNumberOfNetworkMessagesPerType.replace(type, currentValue - 1);
        }
    }

    public NetworkMessage getIncomingNetworkMessage() {
        return this.incomingNetworkMessage;
    }

    public void setIncomingNetworkMessage(NetworkMessage incomingNetworkMessage) {
        this.incomingNetworkMessage = incomingNetworkMessage;
    }

    public void resetFSM() {
        this.cardFSM.reset();
    }

    public void executePhase() {
        this.cardFSM.execute(this);
    }

    public void previousPhase() {
        this.cardFSM.previous();
    }

    public void previousPhase(int iterations) {
        for (int i = 1; i <= iterations; ++i) {
            this.cardFSM.previous();
        }
    }

    public void nextPhase() {
        this.cardFSM.next();
    }

    public void nextPhase(int iterations) {
        for (int i = 1; i <= iterations; ++i) {
            this.cardFSM.next();
        }
    }

    public void goToEndPhase() {
        this.cardFSM.skipToEndState();
    }
}

