/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import it.polimi.ingsw.galaxytrucker.controller.GameController;
import it.polimi.ingsw.galaxytrucker.controller.ServerControllerHandles;
import it.polimi.ingsw.galaxytrucker.controller.adventurecardmanagement.CardContext;
import it.polimi.ingsw.galaxytrucker.enums.ActivatableComponent;
import it.polimi.ingsw.galaxytrucker.enums.AlienColor;
import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.enums.GameAction;
import it.polimi.ingsw.galaxytrucker.enums.GameState;
import it.polimi.ingsw.galaxytrucker.enums.NetworkMessageType;
import it.polimi.ingsw.galaxytrucker.enums.PlayerLostReason;
import it.polimi.ingsw.galaxytrucker.enums.TimerStatus;
import it.polimi.ingsw.galaxytrucker.exceptions.PlayerAlreadyExistsException;
import it.polimi.ingsw.galaxytrucker.exceptions.TooManyPlayersException;
import it.polimi.ingsw.galaxytrucker.model.Player;
import it.polimi.ingsw.galaxytrucker.model.PlayerInfo;
import it.polimi.ingsw.galaxytrucker.model.Ship;
import it.polimi.ingsw.galaxytrucker.model.TileBunch;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.CardDeck;
import it.polimi.ingsw.galaxytrucker.model.essentials.Position;
import it.polimi.ingsw.galaxytrucker.model.essentials.Slot;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.CentralHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.ModularHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.game.TimerInfo;
import it.polimi.ingsw.galaxytrucker.model.utils.Util;
import it.polimi.ingsw.galaxytrucker.network.Heartbeat;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyInfo;
import it.polimi.ingsw.galaxytrucker.network.common.LobbyManager;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.AskTimerInfoRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.CheckShipStatusRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.CreateRoomRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.DiscardTileRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.DrawAdventureCardRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.DrawTileRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.EarlyLandingRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.FinishBuildingRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.FlipTimerRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.HeartbeatRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.JoinRoomRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.JoiniRoomOptionsRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.NicknameRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.PlaceTileRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.requests.ReadyTurnRequest;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.ActivateAdventureCardResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.ActivateComponentResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.AskPositionResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.AskTrunkResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.CheckShipStatusResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.CollectRewardsResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.DiscardCrewMembersResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.DrawTileResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.JoinRoomOptionsResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.JoinRoomResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.NicknameResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.PlaceTileResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.SelectPlanetResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.responses.TimerInfoResponse;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.AskPositionUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.CrewInitUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.DecksUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.FaceUpTileUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.FlightBoardUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.GameMessage;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PhaseUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.PlayerJoinedUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.ShipUpdate;
import it.polimi.ingsw.galaxytrucker.network.common.NetworkMessages.updates.TileDiscardedUpdate;
import it.polimi.ingsw.galaxytrucker.network.server.ClientHandler;
import it.polimi.ingsw.galaxytrucker.network.server.MessageManager;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.PrinterLabels;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.PrinterUtils;
import it.polimi.ingsw.galaxytrucker.view.Tui.util.TuiColor;
import it.polimi.ingsw.galaxytrucker.visitors.Network.NetworkMessageNameVisitor;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentNameVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.util.Pair;

public class ServerController
extends UnicastRemoteObject
implements ServerControllerHandles {
    private final HashMap<Integer, LobbyManager> lobbyManagers;
    private final MessageManager messageManager;
    private final ArrayList<ClientHandler> clients = new ArrayList();
    private final HashMap<UUID, String> clientNicknameMap = new HashMap();
    private final ArrayList<LobbyInfo> lobbyInfos = new ArrayList();
    private final ArrayList<Heartbeat> heartbeats = new ArrayList();
    private ArrayList<Tile> gameTiles;
    private static final NetworkMessageNameVisitor networkMessageNameVisitor = new NetworkMessageNameVisitor();
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private boolean synchronousExecution = false;
    private static Integer nextLobbyIndex = 0;
    private static final Map<GameState, Set<GameAction>> allowedActionsPerState = new EnumMap<GameState, Set<GameAction>>(GameState.class);

    public void setSynchronousExecution(boolean sync) {
        this.synchronousExecution = sync;
    }

    public void execute(Runnable task) {
        if (this.synchronousExecution) {
            task.run();
        } else {
            executor.submit(task);
        }
    }

    public ServerController() throws RemoteException {
        this.lobbyManagers = new HashMap();
        this.messageManager = new MessageManager(this);
        this.initActionsAllowed();
        this.generateGameTiles();
    }

    public void generateGameTiles() {
        ObjectMapper mapper = new ObjectMapper();
        String path = "tiledata.json";
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(path);){
            if (in == null) {
                System.err.println(path + " not found.");
            } else {
                this.gameTiles = (ArrayList)mapper.readValue(in, new TypeReference<List<Tile>>(this){});
            }
        }
        catch (IOException e) {
            System.err.println("Error while reading " + path + " : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(ClientHandler client) {
        ArrayList<ClientHandler> arrayList = this.clients;
        synchronized (arrayList) {
            this.clients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ClientHandler> getClients() {
        ArrayList<ClientHandler> arrayList = this.clients;
        synchronized (arrayList) {
            return this.clients;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(ClientHandler client) {
        Cloneable cloneable;
        String nickname = this.getNicknameFromClientHandler(client);
        LobbyManager game = this.getLobbyFromHandler(client);
        if (game != null) {
            game.getGameController().kickPlayerFromGame(nickname);
            cloneable = this.lobbyInfos;
            synchronized (cloneable) {
                this.lobbyInfos.removeIf(l -> l.getLobbyID() == game.getGameID());
            }
            cloneable = this.lobbyManagers;
            synchronized (cloneable) {
                this.lobbyManagers.remove(game.getGameID());
            }
        }
        if (nickname != null && !nickname.isBlank()) {
            cloneable = this.clientNicknameMap;
            synchronized (cloneable) {
                this.clientNicknameMap.remove(client.getClientID());
            }
        }
        cloneable = this.clients;
        synchronized (cloneable) {
            this.clients.remove(client);
        }
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LobbyManager getLobbyFromHandler(ClientHandler clientHandler) {
        LobbyManager lobbyManager;
        HashMap<Integer, LobbyManager> hashMap = this.lobbyManagers;
        synchronized (hashMap) {
            lobbyManager = this.lobbyManagers.values().stream().filter(gameModel -> gameModel.getPlayerHandlers().values().stream().anyMatch(h -> h.getClientID().equals(clientHandler.getClientID()))).findFirst().orElse(null);
        }
        return lobbyManager;
    }

    @Override
    public void handleNicknameRequest(NicknameRequest message, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            Boolean result = false;
            boolean flag = false;
            String nickname = message.getNickname();
            NicknameResponse nicknameResponse = new NicknameResponse(null, message.getID());
            HashMap<UUID, String> hashMap = this.clientNicknameMap;
            synchronized (hashMap) {
                if (!this.clientNicknameMap.containsValue(nickname)) {
                    this.clientNicknameMap.put(clientHandler.getClientID(), nickname);
                    nicknameResponse.setResponse("VALID");
                } else {
                    System.out.println("[+] NOT ADDED " + message.getNickname());
                    nicknameResponse.setResponse("INVALID");
                }
            }
            clientHandler.sendMessage(nicknameResponse);
        });
    }

    @Override
    public void handleCreateRoomRequest(CreateRoomRequest message, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager newGame;
            String tempNick = message.getNickName();
            HashMap<Integer, LobbyManager> hashMap = this.lobbyManagers;
            synchronized (hashMap) {
                newGame = new LobbyManager(nextLobbyIndex);
                this.lobbyManagers.put(newGame.getGameID(), newGame);
                Integer $727861082 = nextLobbyIndex;
                nextLobbyIndex = nextLobbyIndex + 1;
            }
            Player myPlayer = new Player(message.getNickName(), 0, 0, message.getIsLearningMatch());
            Color myColor = newGame.useNextAvailableColor();
            myPlayer.setColor(myColor);
            newGame.getPlayerColors().putIfAbsent(message.getNickName(), myColor);
            newGame.getRealGame().setLearningMatch(message.getIsLearningMatch());
            newGame.getRealGame().setnMaxPlayer(message.getMaxPlayers());
            try {
                newGame.getRealGame().addPlayer(myPlayer);
            }
            catch (PlayerAlreadyExistsException | TooManyPlayersException e) {
                System.err.println(e.getMessage());
                return;
            }
            newGame.addPlayerHandler(clientHandler, myPlayer.getNickName());
            if (message.isSubscribedToTimerUpdates()) {
                newGame.getTimerSubscribers().add(clientHandler);
            }
            newGame.getRealGame().initFlightBoard();
            Tile centralTile = null;
            for (Tile tile : this.gameTiles) {
                CentralHousingUnit centralHousingUnit;
                if (!tile.getMyComponent().accept(new ComponentNameVisitor()).equals("CentralHousingUnit") || !(centralHousingUnit = (CentralHousingUnit)tile.getMyComponent()).getIsColored().booleanValue() || !centralHousingUnit.getColor().equals((Object)myColor)) continue;
                centralTile = tile;
            }
            myPlayer.getShip().putTile(centralTile, new Position(3, 2));
            ArrayList<LobbyInfo> i$ = this.lobbyInfos;
            synchronized (i$) {
                this.lobbyInfos.add(new LobbyInfo(message.getNickName(), message.getMaxPlayers(), 1, newGame.getGameID(), message.getIsLearningMatch()));
            }
            JoinRoomResponse joinRoomResponse = new JoinRoomResponse(message.getID());
            joinRoomResponse.setOperationSuccess(true);
            joinRoomResponse.setColor(myColor);
            joinRoomResponse.setMyShip(myPlayer.getShip());
            joinRoomResponse.setIsLearningMatch(newGame.getRealGame().getIsLearningMatch());
            PlayerInfo playerInfo1 = new PlayerInfo();
            playerInfo1.setShip(myPlayer.getShip());
            playerInfo1.setNickName(myPlayer.getNickName());
            playerInfo1.setColor(myColor);
            newGame.addPlayerInfo(playerInfo1);
            clientHandler.sendMessage(joinRoomResponse);
            clientHandler.sendMessage(new FlightBoardUpdate(newGame.getRealGame().getFlightBoard()));
        });
    }

    @Override
    public void handleJoinRoomOptionsRequest(JoiniRoomOptionsRequest message, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            JoinRoomOptionsResponse joinRoomOptionsResponse;
            new JoinRoomOptionsResponse(null, message.getID());
            ArrayList<LobbyInfo> arrayList = this.lobbyInfos;
            synchronized (arrayList) {
                joinRoomOptionsResponse = new JoinRoomOptionsResponse(this.lobbyInfos, message.getID());
            }
            clientHandler.sendMessage(joinRoomOptionsResponse);
        });
    }

    @Override
    public void handleJoinRoomRequest(JoinRoomRequest message, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            Object mess = "";
            JoinRoomResponse joinRoomResponse = new JoinRoomResponse(message.getID());
            boolean result = false;
            LobbyManager myGame = this.lobbyManagers.get(message.getRoomId());
            if (myGame == null) {
                mess = "Lobby number " + message.getRoomId() + " doesn't exist. Try again.";
                joinRoomResponse.setErrMess((String)mess);
                joinRoomResponse.setOperationSuccess(false);
                joinRoomResponse.setColor(null);
                clientHandler.sendMessage(joinRoomResponse);
                return;
            }
            LobbyManager lobbyManager = myGame;
            synchronized (lobbyManager) {
                LobbyInfo myLobbyInfo;
                if (myGame.getPlayerColors().size() == myGame.getRealGame().getMaxPlayers().intValue() || myGame.getGameController().getGameState() != GameState.LOBBY) {
                    mess = PrinterUtils.getTextWithLabel(PrinterLabels.LobbyInfo, TuiColor.RED, "LOBBY" + message.getRoomId() + "DOESN'T MUNGI YOU");
                    joinRoomResponse.setErrMess((String)mess);
                    joinRoomResponse.setOperationSuccess(false);
                    joinRoomResponse.setColor(null);
                    clientHandler.sendMessage(joinRoomResponse);
                    return;
                }
                Player myPlayer = new Player(message.getNickName(), 0, 0, myGame.getRealGame().getIsLearningMatch());
                mess = PrinterUtils.getTextWithLabel(PrinterLabels.LobbyInfo, TuiColor.GREEN, "CONNECTED TO LOBBY " + message.getRoomId());
                Color myColor = myGame.useNextAvailableColor();
                myGame.getPlayerColors().putIfAbsent(message.getNickName(), myColor);
                myPlayer.setColor(myColor);
                Tile centralTile = null;
                for (Tile tile : this.gameTiles) {
                    CentralHousingUnit centralHousingUnit;
                    if (!tile.getMyComponent().accept(new ComponentNameVisitor()).equals("CentralHousingUnit") || !(centralHousingUnit = (CentralHousingUnit)tile.getMyComponent()).getIsColored().booleanValue() || !centralHousingUnit.getColor().equals((Object)myColor)) continue;
                    centralTile = tile;
                    break;
                }
                myPlayer.getShip().putTile(centralTile, new Position(3, 2));
                try {
                    myGame.getRealGame().addPlayer(myPlayer);
                }
                catch (PlayerAlreadyExistsException | TooManyPlayersException e) {
                    throw new RuntimeException(e);
                }
                myGame.addPlayerHandler(clientHandler, myPlayer.getNickName());
                ArrayList<ClientHandler> playerHandlers = new ArrayList<ClientHandler>(myGame.getPlayerHandlers().values());
                PlayerInfo playerInfo1 = new PlayerInfo();
                playerInfo1.setShip(myPlayer.getShip());
                playerInfo1.setNickName(myPlayer.getNickName());
                playerInfo1.setColor(myColor);
                PlayerJoinedUpdate playerJoinedUpdate = new PlayerJoinedUpdate(playerInfo1);
                ArrayList<LobbyInfo> arrayList = this.lobbyInfos;
                synchronized (arrayList) {
                    myLobbyInfo = this.lobbyInfos.stream().filter(l -> l.getLobbyID() == message.getRoomId()).findFirst().orElse(null);
                }
                joinRoomResponse.setErrMess((String)mess);
                joinRoomResponse.setOperationSuccess(true);
                joinRoomResponse.setColor(myColor);
                joinRoomResponse.setMyShip(myPlayer.getShip());
                myGame.addPlayerInfo(playerInfo1);
                if (myLobbyInfo != null) {
                    myLobbyInfo.addConnectedPlayer();
                    result = true;
                } else {
                    mess = PrinterUtils.getTextWithLabel(PrinterLabels.LobbyInfo, TuiColor.RED, "LOBBY NOT FOUND :) " + message.getRoomId());
                    joinRoomResponse.setOperationSuccess(false);
                    joinRoomResponse.setColor(null);
                    joinRoomResponse.setMyShip(null);
                }
                PlayerInfo hostPlayerInfo = new PlayerInfo();
                hostPlayerInfo.setNickName(myLobbyInfo.getHost());
                hostPlayerInfo.setShip(myGame.getRealGame().getPlayer(myLobbyInfo.getHost()).getShip());
                hostPlayerInfo.setColor(myGame.getPlayerColors().get(myLobbyInfo.getHost()));
                joinRoomResponse.setIsLearningMatch(myLobbyInfo.isLearningMatch());
                if (result) {
                    joinRoomResponse.setPlayerInfos(myGame.getPlayerInfos());
                }
                clientHandler.sendMessage(new FlightBoardUpdate(myGame.getRealGame().getFlightBoard()));
                clientHandler.sendMessage(joinRoomResponse);
                if (result) {
                    if (message.isSubscribedToTimerUpdates()) {
                        myGame.getTimerSubscribers().add(clientHandler);
                    }
                    ArrayList<ClientHandler> original = new ArrayList<ClientHandler>(playerHandlers);
                    playerHandlers.remove(clientHandler);
                    playerJoinedUpdate.setPlayersJoinedBefore(myGame.getPlayerInfos());
                    this.broadCast(playerHandlers, playerJoinedUpdate);
                    if (myGame.getRealGame().getMaxPlayers().intValue() == myGame.getRealGame().getNumPlayers()) {
                        myGame.getRealGame().createDecks();
                        ArrayList<CardDeck> decks = myGame.getRealGame().getDecks();
                        DecksUpdate decksUpdate = new DecksUpdate();
                        decksUpdate.setDecks(decks);
                        decksUpdate.setFlightDeck(null);
                        myGame.getGameController().nextState();
                        this.broadCast(original, decksUpdate);
                        this.broadCast(original, new PhaseUpdate(GameState.BUILDING_START));
                    }
                }
            }
        });
    }

    @Override
    public void handleDrawTileRequest(DrawTileRequest message, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            DrawTileResponse drawTileResponse;
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            Player player = this.getPlayerFromClientHandler(clientHandler);
            Ship targetShip = player.getShip();
            ArrayList<ClientHandler> playerHandlers = new ArrayList<ClientHandler>(myGame.getPlayerHandlers().values());
            if (!this.isActionAllowed(myGame, GameAction.DRAW_TILE)) {
                DrawTileResponse drawTileResponse2 = new DrawTileResponse(null, message.getID());
                drawTileResponse2.setErrorMessage("INVALID_STATE");
                clientHandler.sendMessage(drawTileResponse2);
                return;
            }
            TileBunch tileBunch = myGame.getTileBunch();
            synchronized (tileBunch) {
                if (message.getTile() != null) {
                    Tile myTile = myGame.getTileBunch().drawFaceUpTile(message.getTile().getId());
                    if (myTile == null) {
                        drawTileResponse = new DrawTileResponse(null, message.getID());
                        drawTileResponse.setErrorMessage("TAKEN");
                    } else {
                        drawTileResponse = new DrawTileResponse(myTile, message.getID());
                        drawTileResponse.setErrorMessage("VALID");
                    }
                    FaceUpTileUpdate faceUpTileUpdate = new FaceUpTileUpdate();
                    faceUpTileUpdate.setFaceUpTiles(myGame.getTileBunch().getFaceUpTiles());
                    this.broadCast(playerHandlers, faceUpTileUpdate);
                } else if (message.isNeedLastTile()) {
                    Tile lastTile = targetShip.getLastTile();
                    if (lastTile == null) {
                        drawTileResponse = new DrawTileResponse(null, message.getID());
                        drawTileResponse.setErrorMessage("NO_TILE");
                    } else if (lastTile.getFixed().booleanValue()) {
                        drawTileResponse = new DrawTileResponse(null, message.getID());
                        drawTileResponse.setErrorMessage("FIXED");
                    } else {
                        targetShip.removeTile(targetShip.getLastTilePosition(), true);
                        targetShip.setLastTile(null);
                        ShipUpdate shipUpdate = new ShipUpdate(targetShip, player.getNickName());
                        this.broadCast(playerHandlers, shipUpdate);
                        drawTileResponse = new DrawTileResponse(lastTile, message.getID());
                        drawTileResponse.setErrorMessage("VALID");
                    }
                } else if (message.isFromReserved()) {
                    int index;
                    Tile[] reserverd = targetShip.getAsideTiles();
                    Tile removedTile = reserverd[index = message.getReservedSlotIndex()];
                    if (removedTile == null) {
                        drawTileResponse = new DrawTileResponse(null, message.getID());
                        drawTileResponse.setErrorMessage("NO_TILE_AT_INDEX");
                    } else {
                        reserverd[index] = null;
                        drawTileResponse = new DrawTileResponse(removedTile, message.getID());
                        drawTileResponse.setErrorMessage("VALID");
                        ShipUpdate shipUpdate = new ShipUpdate(targetShip, player.getNickName());
                        this.broadCast(playerHandlers, shipUpdate);
                    }
                } else {
                    Tile myTile = myGame.getTileBunch().drawTile();
                    if (myTile == null) {
                        drawTileResponse = new DrawTileResponse(null, message.getID());
                        drawTileResponse.setErrorMessage("EMPTY");
                    } else {
                        drawTileResponse = new DrawTileResponse(myTile, message.getID());
                        drawTileResponse.setErrorMessage("VALID");
                    }
                }
            }
            clientHandler.sendMessage(drawTileResponse);
        });
    }

    @Override
    public void handleCheckShipStatusRequest(CheckShipStatusRequest message, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            Player player = this.getPlayerFromClientHandler(clientHandler);
            Ship ship = player.getShip();
            List<Slot> Slots = Arrays.stream(ship.getShipBoard()).flatMap(Arrays::stream).filter(Objects::nonNull).toList();
            for (Slot slot2 : Slots) {
                if (slot2.getTile() == null || !message.getRemovedTilesId().contains(slot2.getTile().getId())) continue;
                ship.removeTile(slot2.getPosition(), true);
            }
            Position pos = Arrays.stream(ship.getShipBoard()).flatMap(Arrays::stream).filter(Objects::nonNull).filter(slot -> slot.getTile() != null && slot.getTile().getMyComponent() != null).map(Slot::getPosition).toList().getFirst();
            Boolean result1 = Util.checkShipStructure(ship, pos).getKey();
            Boolean result = result1 != false ? ship.checkShip() : Boolean.valueOf(false);
            ShipUpdate shipUpdate = new ShipUpdate(ship, player.getNickName());
            CheckShipStatusResponse response = new CheckShipStatusResponse(ship, result, message.getID());
            clientHandler.sendMessage(shipUpdate);
            clientHandler.sendMessage(response);
            ArrayList<ClientHandler> playerHandlers = new ArrayList<ClientHandler>(myGame.getPlayerHandlers().values());
            this.broadCast(playerHandlers, shipUpdate);
            if (result.booleanValue()) {
                Object object = myGame.checkShipLock;
                synchronized (object) {
                    myGame.getGameController().addCompletedShip();
                    if (myGame.getRealGame().getNumPlayers() == myGame.getGameController().getnCompletedShips() && !myGame.getGameController().getGameState().equals((Object)GameState.CREW_INIT)) {
                        myGame.getGameController().nextState();
                        Tile centralTile = ship.getTileFromPosition(new Position(3, 2));
                        CentralHousingUnit centralHousingUnit = (CentralHousingUnit)centralTile.getMyComponent();
                        centralHousingUnit.setHumanCrewNumber(2);
                        ShipUpdate shipUpdate2 = new ShipUpdate(ship, player.getNickName());
                        PhaseUpdate phaseUpdate = new PhaseUpdate(GameState.CREW_INIT);
                        this.broadCast(playerHandlers, shipUpdate2);
                        this.broadCast(playerHandlers, phaseUpdate);
                    }
                }
            }
        });
    }

    @Override
    public void handleAskPositionResponse(AskPositionResponse askPositionResponse, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            try {
                this.handleFinishBuildingRequest2(askPositionResponse, clientHandler);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void handleSelectPlanetResponse(SelectPlanetResponse selectPlanetResponse, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager game = this.getLobbyFromHandler(clientHandler);
            game.getGameController().getCurrentCardContext().setIncomingNetworkMessage(selectPlanetResponse);
            this.tryExecutePhaseAfterMessage(game, NetworkMessageType.SelectPlanetResponse);
        });
    }

    @Override
    public void handleAskTrunkResponse(AskTrunkResponse askTrunkResponse, ClientHandler clientHandler) {
        this.execute(() -> {
            LobbyManager game = this.getLobbyFromHandler(clientHandler);
            game.getGameController().getCurrentCardContext().setIncomingNetworkMessage(askTrunkResponse);
            this.tryExecutePhaseAfterMessage(game, NetworkMessageType.AskTrunkResponse);
        });
    }

    @Override
    public void handleFinishBuildingRequest(FinishBuildingRequest finishBuildingRequest, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            String nickname = this.getNicknameFromClientHandler(clientHandler);
            ArrayList<Integer> validPos = new ArrayList<Integer>();
            Object object = myGame.positionLock;
            synchronized (object) {
                int maxPos = myGame.getRealGame().getNumPlayers();
                boolean minPos = true;
                ArrayList<Integer> takenPos = myGame.getRealGame().getFlightBoard().getOccupiedPositions();
                for (int i = 1; i <= maxPos; ++i) {
                    int realPos = 0;
                    switch (i) {
                        case 1: {
                            realPos = myGame.getRealGame().getFlightBoard().getFlightBoardMap().getFirstPos();
                            break;
                        }
                        case 2: {
                            realPos = myGame.getRealGame().getFlightBoard().getFlightBoardMap().getSecondPos();
                            break;
                        }
                        case 3: {
                            realPos = myGame.getRealGame().getFlightBoard().getFlightBoardMap().getThirdPos();
                            break;
                        }
                        case 4: {
                            realPos = myGame.getRealGame().getFlightBoard().getFlightBoardMap().getFourthPos();
                        }
                    }
                    if (takenPos.contains(realPos)) continue;
                    validPos.add(i);
                }
                AskPositionUpdate askPositionUpdate = new AskPositionUpdate(validPos);
                askPositionUpdate.nickname = nickname;
                CompletableFuture<NetworkMessage> future = new CompletableFuture<NetworkMessage>();
                myGame.addPendingResponse(future, askPositionUpdate.getID());
                clientHandler.sendMessage(askPositionUpdate);
            }
        });
    }

    @Override
    public void handleFinishBuildingRequest2(AskPositionResponse askPositionResponse, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            Boolean flag = false;
            Boolean validChoice = true;
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            String nickname = this.getNicknameFromClientHandler(clientHandler);
            Color playerColor = myGame.getPlayerColors().get(nickname);
            ArrayList<ClientHandler> playerHandlers = new ArrayList<ClientHandler>(myGame.getPlayerHandlers().values());
            int realPos = 0;
            Object object = myGame.positionLock;
            synchronized (object) {
                ArrayList<Integer> takenPos = myGame.getRealGame().getFlightBoard().getOccupiedPositions();
                switch (askPositionResponse.getPosition()) {
                    case 1: {
                        realPos = myGame.getRealGame().getFlightBoard().getFlightBoardMap().getFirstPos();
                        break;
                    }
                    case 2: {
                        realPos = myGame.getRealGame().getFlightBoard().getFlightBoardMap().getSecondPos();
                        break;
                    }
                    case 3: {
                        realPos = myGame.getRealGame().getFlightBoard().getFlightBoardMap().getThirdPos();
                        break;
                    }
                    case 4: {
                        realPos = myGame.getRealGame().getFlightBoard().getFlightBoardMap().getFourthPos();
                    }
                }
                if (takenPos.contains(realPos)) {
                    validChoice = false;
                } else {
                    myGame.getRealGame().getFlightBoard().positionPlayer(playerColor, realPos, this.getPlayerFromClientHandler(clientHandler));
                    myGame.getRealGame().getPlayer(nickname).setPlacement(askPositionResponse.getPosition());
                    myGame.addPlayerShipFinished(nickname);
                }
            }
            if (!validChoice.booleanValue()) {
                try {
                    this.handleFinishBuildingRequest(null, clientHandler);
                    return;
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
            this.broadCast(playerHandlers, new FlightBoardUpdate(myGame.getRealGame().getFlightBoard()));
            Ship e = myGame.getRealGame().getPlayer(nickname).getShip();
            synchronized (e) {
                Ship myShip = myGame.getRealGame().getPlayer(nickname).getShip();
                Tile lastTile = myGame.getRealGame().getPlayer(nickname).getShip().getLastTile();
                if (lastTile != null) {
                    int lastTileId = lastTile.getId();
                    List<Slot> slots = Arrays.stream(myShip.getShipBoard()).flatMap(Arrays::stream).filter(Objects::nonNull).toList();
                    for (Slot slot : slots) {
                        if (slot.getTile() == null || slot.getTile().getId() != lastTileId) continue;
                        myShip.getShipBoard()[slot.getPosition().getX()][slot.getPosition().getY()].getTile().setFixed(true);
                        break;
                    }
                }
                this.broadCast(playerHandlers, new ShipUpdate(myShip, nickname));
            }
            System.out.println("N giocatori che hanno finito: " + myGame.getPlayerShipFinishedSize());
            if (myGame.getPlayerShipFinishedSize() == myGame.getRealGame().getNumPlayers()) {
                for (ClientHandler handler : playerHandlers) {
                    Player player = this.getPlayerFromClientHandler(handler);
                    Ship ship = player.getShip();
                    ship.setInitialTiles(ship.remainingTiles());
                }
                myGame.getGameController().nextState();
                System.out.println("Fase successiva: " + myGame.getGameController().getGameState().toString());
                if (myGame.getGameController().getGameState().equals((Object)GameState.BUILDING_END)) {
                    myGame.getGameController().nextState();
                    this.broadCast(playerHandlers, new PhaseUpdate(GameState.SHIP_CHECK));
                } else if (myGame.getGameController().getGameState().equals((Object)GameState.SHIP_CHECK)) {
                    this.broadCast(playerHandlers, new PhaseUpdate(GameState.SHIP_CHECK));
                }
            }
        });
    }

    @Override
    public void handlePlaceTileRequest(PlaceTileRequest placeTileRequest, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            PlaceTileResponse placeTileResponse = new PlaceTileResponse(null, placeTileRequest.getID());
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            String nickname = this.getNicknameFromClientHandler(clientHandler);
            Player myPlayer = myGame.getRealGame().getPlayer(nickname);
            Ship myShip = myPlayer.getShip();
            if (!this.isActionAllowed(myGame, GameAction.PLACE_TILE)) {
                placeTileResponse.setMessage("INVALID_STATE");
                clientHandler.sendMessage(placeTileResponse);
                return;
            }
            Ship ship = myShip;
            synchronized (ship) {
                Tile myTile = placeTileRequest.getTile();
                if (placeTileRequest.isToReserved()) {
                    int index = placeTileRequest.getReservedSlotIndex();
                    myShip.getAsideTiles()[index] = myTile;
                    placeTileResponse.setMessage("VALID");
                } else {
                    Position myPos = placeTileRequest.getPos();
                    if (myShip.getInvalidPositions().contains(myPos)) {
                        placeTileResponse.setMessage("INVALID_POS");
                        clientHandler.sendMessage(placeTileResponse);
                        return;
                    }
                    if (myShip.getTileFromPosition(myPos) != null) {
                        placeTileResponse.setMessage("OCCUPIED_POS");
                        clientHandler.sendMessage(placeTileResponse);
                        return;
                    }
                    myShip.putTile(myTile, myPos);
                    myShip.setLastTile(myTile);
                    myShip.setLastTilePosition(myPos);
                    placeTileResponse.setMessage("VALID");
                }
                ArrayList<ClientHandler> playerHandlers = new ArrayList<ClientHandler>(myGame.getPlayerHandlers().values());
                ShipUpdate shipUpdate = new ShipUpdate(myShip, myPlayer.getNickName());
                this.broadCast(playerHandlers, shipUpdate);
                clientHandler.sendMessage(placeTileResponse);
            }
        });
    }

    @Override
    public void handleDiscardTileRequest(DiscardTileRequest discardTileRequest, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            String nickname = this.getNicknameFromClientHandler(clientHandler);
            Player myPlayer = myGame.getRealGame().getPlayer(nickname);
            myGame.getTileBunch().returnTile(discardTileRequest.getTile());
            ArrayList<ClientHandler> playerHandlers = new ArrayList<ClientHandler>(myGame.getPlayerHandlers().values());
            this.broadCast(playerHandlers, new TileDiscardedUpdate(discardTileRequest.getTile()));
            FaceUpTileUpdate faceUpTileUpdate = new FaceUpTileUpdate();
            faceUpTileUpdate.setFaceUpTiles(myGame.getTileBunch().getFaceUpTiles());
            this.broadCast(playerHandlers, faceUpTileUpdate);
        });
    }

    @Override
    public void handleCrewInitUpdate(CrewInitUpdate crewInitUpdate, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            Player myPlayer = this.getPlayerFromClientHandler(clientHandler, myGame);
            Ship myShip = myPlayer.getShip();
            ArrayList<Position> positions = new ArrayList<Position>(crewInitUpdate.getCrewPos().stream().map(Pair::getKey).toList());
            List<Slot> Slots = Arrays.stream(myShip.getShipBoard()).flatMap(Arrays::stream).filter(Objects::nonNull).toList();
            for (Slot s : Slots) {
                Tile tempTile = s.getTile();
                Position tempPos = s.getPosition();
                if (!positions.contains(tempPos) || s.getTile() == null) continue;
                AlienColor color = crewInitUpdate.getCrewPos().stream().filter(pair -> ((Position)pair.getKey()).equals(tempPos)).map(Pair::getValue).findFirst().orElse(null);
                if (color == null) {
                    return;
                }
                if (color.equals((Object)AlienColor.PURPLE)) {
                    ModularHousingUnit purpleHousing = (ModularHousingUnit)tempTile.getMyComponent();
                    purpleHousing.addPurpleAlien();
                }
                if (color.equals((Object)AlienColor.BROWN)) {
                    ModularHousingUnit brownHousing = (ModularHousingUnit)tempTile.getMyComponent();
                    brownHousing.addBrownAlien();
                    continue;
                }
                ModularHousingUnit humanHousing = (ModularHousingUnit)tempTile.getMyComponent();
                humanHousing.addHumanCrew();
            }
            ArrayList<ClientHandler> playerHandlers = new ArrayList<ClientHandler>(myGame.getPlayerHandlers().values());
            ShipUpdate shipUpdate = new ShipUpdate(myShip, myPlayer.getNickName());
            this.broadCast(playerHandlers, shipUpdate);
            myGame.addPlayerCrewFinished(myPlayer.getNickName());
            if (myGame.getPlayerCrewSize() == myGame.getRealGame().getNumPlayers()) {
                myGame.getGameController().nextState();
                PhaseUpdate phaseUpdate = new PhaseUpdate(GameState.FLIGHT);
                this.broadCast(playerHandlers, phaseUpdate);
                try {
                    myGame.getGameController().startFlight();
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void handleActivateAdventureCardResponse(ActivateAdventureCardResponse activateAdventureCardResponse, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager game = this.getLobbyFromHandler(clientHandler);
            GameController gameController = game.getGameController();
            synchronized (gameController) {
                game.getGameController().notify();
            }
            game.getGameController().getCurrentCardContext().setIncomingNetworkMessage(activateAdventureCardResponse);
            this.tryExecutePhaseAfterMessage(game, NetworkMessageType.ActivateAdventureCardResponse);
        });
    }

    @Override
    public void handleActivateComponentResponse(ActivateComponentResponse activateComponentResponse, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager game = this.getLobbyFromHandler(clientHandler);
            Player player = this.getPlayerFromClientHandler(clientHandler);
            Ship ship = player.getShip();
            ActivatableComponent activatableComponent = activateComponentResponse.getActivatableComponentType();
            ArrayList<Position> activatedComponentPositions = activateComponentResponse.getActivatedComponentPositions();
            ArrayList<Position> batteriesPositions = activateComponentResponse.getBatteriesPositions();
            if (activatedComponentPositions == null || batteriesPositions == null || activatedComponentPositions.isEmpty() || batteriesPositions.isEmpty()) {
                this.tryExecutePhaseAfterMessage(game, NetworkMessageType.ActivateComponentResponse);
                return;
            }
            block5: for (int i = 0; i < activateComponentResponse.getActivatedComponentPositions().size(); ++i) {
                Position componentPos = activatedComponentPositions.get(i);
                Position batteryPos = batteriesPositions.get(i);
                switch (activatableComponent) {
                    case DoubleEngine: {
                        ship.activateDoubleEngine(componentPos, batteryPos);
                        continue block5;
                    }
                    case DoubleCannon: {
                        ship.activateDoubleCannon(componentPos, batteryPos);
                        continue block5;
                    }
                    case Shield: {
                        ship.activateShield(componentPos, batteryPos);
                    }
                }
            }
            ShipUpdate shipUpdate = new ShipUpdate(ship, player.getNickName());
            ArrayList<ClientHandler> playerHandlers = new ArrayList<ClientHandler>(game.getPlayerHandlers().values());
            this.broadCast(playerHandlers, shipUpdate);
            this.tryExecutePhaseAfterMessage(game, NetworkMessageType.ActivateComponentResponse);
        });
    }

    @Override
    public void handleHeartbeatRequest(HeartbeatRequest ignoredHeartbeatRequest, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            ArrayList<Heartbeat> arrayList = this.heartbeats;
            synchronized (arrayList) {
                this.heartbeats.stream().filter(h -> h.getClientHandler().getClientID().equals(clientHandler.getClientID())).findFirst().ifPresent(h -> {
                    this.heartbeats.remove(h);
                    h.regenerate();
                });
            }
        });
    }

    @Override
    public void handleShipUpdate(ShipUpdate shipUpdate, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            Player myPlayer;
            String nickname;
            LobbyManager game = this.getLobbyFromHandler(clientHandler);
            if (shipUpdate.getOnlyFix().booleanValue()) {
                nickname = this.getNicknameFromClientHandler(clientHandler);
                myPlayer = game.getRealGame().getPlayer(nickname);
                Ship myShip = myPlayer.getShip();
                if (myShip.getLastTile() != null) {
                    Ship ship = myShip;
                    synchronized (ship) {
                        myShip.getLastTile().setFixed(true);
                    }
                }
                ShipUpdate update = new ShipUpdate(myShip, myPlayer.getNickName());
                ArrayList<ClientHandler> playerHandlers = new ArrayList<ClientHandler>(game.getPlayerHandlers().values());
                this.broadCast(playerHandlers, update);
            }
            if (game.getGameController().getGameState() == GameState.FLIGHT && game.getGameController().getCurrentCardContext() != null) {
                nickname = this.getNicknameFromClientHandler(clientHandler);
                myPlayer = game.getRealGame().getPlayer(nickname);
                myPlayer.replaceShip(shipUpdate.getShipView());
                game.getGameController().getCurrentCardContext().setIncomingNetworkMessage(shipUpdate);
                this.tryExecutePhaseAfterMessage(game, shipUpdate.accept(networkMessageNameVisitor));
            }
        });
    }

    @Override
    public void handleDiscardCrewMembersResponse(DiscardCrewMembersResponse discardCrewMembersResponse, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager game = this.getLobbyFromHandler(clientHandler);
            game.getGameController().getCurrentCardContext().setIncomingNetworkMessage(discardCrewMembersResponse);
            this.tryExecutePhaseAfterMessage(game, discardCrewMembersResponse.accept(networkMessageNameVisitor));
        });
    }

    @Override
    public void handleCollectRewardsResponse(CollectRewardsResponse collectRewardsResponse, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager game = this.getLobbyFromHandler(clientHandler);
            game.getGameController().getCurrentCardContext().setIncomingNetworkMessage(collectRewardsResponse);
            this.tryExecutePhaseAfterMessage(game, collectRewardsResponse.accept(networkMessageNameVisitor));
        });
    }

    @Override
    public void handleDrawAdventureCardRequest(DrawAdventureCardRequest drawAdventureCardRequest, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            GameController gameController = myGame.getGameController();
            if (gameController.getCurrentCardContext() != null) {
                clientHandler.sendMessage(new GameMessage("\u00c8 gi\u00e0 in corso una carta avventura."));
                return;
            }
            gameController.handleTurn();
        });
    }

    @Override
    public void handleReadyTurnRequest(ReadyTurnRequest readyTurnRequest, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            String nickname = this.getNicknameFromClientHandler(clientHandler);
            GameController gameController = myGame.getGameController();
            try {
                new Thread(() -> {
                    myGame.addReadyPlayer(nickname);
                    if (myGame.allActivePlayerReady()) {
                        gameController.sendMatchInfoUpdate();
                    }
                }).start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void handleEarlyLandingRequest(EarlyLandingRequest earlyLandingRequest, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            String nickname = this.getNicknameFromClientHandler(clientHandler);
            GameController gameController = myGame.getGameController();
            myGame.getGameController().removePlayerFromGame(nickname, PlayerLostReason.Quit);
            new Thread(() -> {
                myGame.addEarlyLandingPlayer(nickname);
                if (myGame.allActivePlayerReady()) {
                    gameController.sendMatchInfoUpdate();
                }
            }).start();
        });
    }

    @Override
    public void handleAskTimerInfoRequest(AskTimerInfoRequest askTimerInfoRequest, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            TimerInfoResponse timerInfoResponse = new TimerInfoResponse(askTimerInfoRequest.getID(), myGame.getRealGame().getTimerInfos());
            ArrayList<TimerInfo> timerInfos = myGame.getRealGame().getTimerInfos();
            clientHandler.sendMessage(timerInfoResponse);
        });
    }

    @Override
    public void handleFlipTimerRequest(FlipTimerRequest flipTimerRequest, ClientHandler clientHandler) throws RemoteException {
        this.execute(() -> {
            LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
            Object object = myGame.timerLock;
            synchronized (object) {
                ArrayList<TimerInfo> timerInfos = myGame.getRealGame().getTimerInfos();
                TimerInfo timer = timerInfos.stream().filter(t -> !t.isFlipped()).findFirst().orElse(null);
                if (timer == null) {
                    return;
                }
                timer.setFlipped(true);
                boolean lastTimer = timer.getIndex() == myGame.getRealGame().getTimerInfos().size() - 1;
                this.startTimer(10, myGame.getGameController(), new ArrayList<ClientHandler>(myGame.getPlayerHandlers().values()), lastTimer, timer.getIndex());
            }
        });
    }

    public void startTimer(int seconds, GameController gameController, ArrayList<ClientHandler> clients, boolean last, int index) {
        GameMessage gameMessage = new GameMessage("Timer n. " + (index + 1) + " started");
        this.broadCast(clients, gameMessage);
        new Thread(() -> {
            TimerInfoResponse timerInfoResponse;
            LobbyManager game = this.getLobbyFromHandler((ClientHandler)clients.getFirst());
            TimerInfo timerinfo = game.getRealGame().getTimerInfos().stream().filter(t -> t.getIndex() == index).findFirst().orElse(null);
            if (timerinfo == null) {
                System.err.println("TimerInfo null");
                return;
            }
            timerinfo.setTimerStatus(TimerStatus.STARTED);
            int secondsIn = seconds;
            timerinfo.setValue(seconds);
            while (secondsIn > 0) {
                try {
                    timerInfoResponse = new TimerInfoResponse(game.getRealGame().getTimerInfos());
                    if (secondsIn == seconds) {
                        this.broadCast(clients, timerInfoResponse);
                    } else {
                        this.broadCast(game.getTimerSubscribers(), timerInfoResponse);
                    }
                    Thread.sleep(1000L);
                    timerinfo.setValue(--secondsIn);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            timerinfo.setTimerStatus(TimerStatus.ENDED);
            timerInfoResponse = new TimerInfoResponse(game.getRealGame().getTimerInfos());
            timerInfoResponse.setLast(last);
            this.broadCast(clients, timerInfoResponse);
        }).start();
    }

    private void tryExecutePhaseAfterMessage(LobbyManager game, NetworkMessageType type) {
        CardContext cardContext = game.getGameController().getCurrentCardContext();
        cardContext.decrementExpectedNumberOfNetworkMessages(type);
        int expectedNetworkMessages = cardContext.getExpectedNumberOfNetworkMessagesPerType().get((Object)type);
        NetworkMessage networkMessage = cardContext.getIncomingNetworkMessage();
        NetworkMessageNameVisitor visitor = new NetworkMessageNameVisitor();
        if (Objects.equals(cardContext.getAdventureCard().getName(), "Pianeti") && networkMessage.accept(visitor).equals((Object)NetworkMessageType.ShipUpdate)) {
            game.getGameController().getCurrentCardContext().executePhase();
            return;
        }
        if (expectedNetworkMessages == 0) {
            game.getGameController().getCurrentCardContext().executePhase();
        } else if (expectedNetworkMessages == -1) {
            game.getGameController().getCurrentCardContext().incrementExpectedNumberOfNetworkMessages(type);
        }
    }

    public void broadCast(ArrayList<ClientHandler> clients, NetworkMessage message) {
        NetworkMessageType networkMessageType = message.accept(networkMessageNameVisitor);
        for (ClientHandler clientHandler : clients) {
            clientHandler.sendMessage(message);
        }
    }

    private void initActionsAllowed() {
        allowedActionsPerState.put(GameState.BUILDING_START, EnumSet.of(GameAction.DRAW_TILE, GameAction.PLACE_TILE, GameAction.DISCARD_TILE));
        allowedActionsPerState.put(GameState.BUILDING_TIMER, EnumSet.of(GameAction.DRAW_TILE, GameAction.PLACE_TILE, GameAction.DISCARD_TILE, GameAction.FINISH_BUILDING));
    }

    private boolean isActionAllowed(LobbyManager myGame, GameAction action) {
        GameState currentState = myGame.getGameController().getGameState();
        Set allowedActions = allowedActionsPerState.getOrDefault((Object)currentState, Collections.emptySet());
        return allowedActions.contains((Object)action);
    }

    public String getNicknameFromClientHandler(ClientHandler clientHandler) {
        return this.clientNicknameMap.get(clientHandler.getClientID());
    }

    private Player getPlayerFromClientHandler(ClientHandler clientHandler) {
        LobbyManager myGame = this.getLobbyFromHandler(clientHandler);
        return myGame.getRealGame().getPlayer(this.getNicknameFromClientHandler(clientHandler));
    }

    private Player getPlayerFromClientHandler(ClientHandler clientHandler, LobbyManager myGame) {
        return myGame.getRealGame().getPlayer(this.getNicknameFromClientHandler(clientHandler));
    }

    public void startNewHeartbeat(ClientHandler clientHandler) {
        Heartbeat heartbeat = new Heartbeat(this, clientHandler);
        this.heartbeats.add(heartbeat);
        heartbeat.start();
    }

    public int getLastCreatedGameId() {
        return nextLobbyIndex - 1;
    }

    public ArrayList<Heartbeat> getHeartbeats() {
        return this.heartbeats;
    }
}

