/*
 * Decompiled with CFR 0.152.
 */
package it.polimi.ingsw.galaxytrucker;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import it.polimi.ingsw.galaxytrucker.enums.AlienColor;
import it.polimi.ingsw.galaxytrucker.enums.Color;
import it.polimi.ingsw.galaxytrucker.enums.Connector;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileDirection;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileSize;
import it.polimi.ingsw.galaxytrucker.enums.ProjectileType;
import it.polimi.ingsw.galaxytrucker.model.Planet;
import it.polimi.ingsw.galaxytrucker.model.Projectile;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AbandonedShip;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AbandonedStation;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.AdventureCard;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.CombatZone;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Epidemic;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.MeteorSwarm;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.OpenSpace;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Pirates;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Planets;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Slavers;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Smugglers;
import it.polimi.ingsw.galaxytrucker.model.adventurecards.Stardust;
import it.polimi.ingsw.galaxytrucker.model.essentials.Component;
import it.polimi.ingsw.galaxytrucker.model.essentials.Good;
import it.polimi.ingsw.galaxytrucker.model.essentials.Tile;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.BatterySlot;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Cannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.CentralHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleCannon;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.DoubleEngine;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Engine;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.GenericCargoHolds;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.LifeSupportSystem;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.ModularHousingUnit;
import it.polimi.ingsw.galaxytrucker.model.essentials.components.Shield;
import it.polimi.ingsw.galaxytrucker.visitors.components.ComponentNameVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;

public class TileCardsJsonUtility
extends Application {
    @FXML
    private StackPane contentPane;
    private Pane tilePane;
    @FXML
    private TextField tileId;
    @FXML
    private TextField extraVal;
    @FXML
    private ComboBox<String> tileComponentType;
    @FXML
    private ComboBox<String> comboBoxTopConn;
    @FXML
    private ComboBox<String> comboBoxRConn;
    @FXML
    private ComboBox<String> comboBoxBotConn;
    @FXML
    private ComboBox<String> comboBoxLConn;
    @FXML
    private ComboBox<String> centralHousingUnitColor;
    @FXML
    private CheckBox specialCargo;
    @FXML
    private ImageView tileImageView;
    private Image tileImage;
    private Pane cartePane;
    @FXML
    private TextField cardId;
    @FXML
    private ImageView imageViewFronte;
    private File immagineFronte;
    @FXML
    private ImageView imageViewRetro;
    private File immagineRetro;
    ObjectMapper mapper = new ObjectMapper();
    ArrayList<Tile> tiles = new ArrayList();
    int tileIndex = 0;
    ComponentNameVisitor componentNameVisitor = new ComponentNameVisitor();
    ArrayList<AdventureCard> cards = new ArrayList();
    int cardIndex = 0;

    @Override
    public void start(Stage primaryStage) throws Exception {
        BorderPane root = new BorderPane();
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Seleziona Vista");
        MenuItem tileMenuItem = new MenuItem("Gestisci Tiles");
        MenuItem carteMenuItem = new MenuItem("Gestisci Carte");
        menu.getItems().addAll((MenuItem[])new MenuItem[]{tileMenuItem, carteMenuItem});
        menuBar.getMenus().add(menu);
        root.setTop(menuBar);
        this.contentPane = new StackPane();
        root.setCenter(this.contentPane);
        try {
            this.tilePane = (Pane)FXMLLoader.load(this.getClass().getResource("JsonUtilityPages/TilePanel.fxml"));
            this.cartePane = (Pane)FXMLLoader.load(this.getClass().getResource("JsonUtilityPages/CardsPanel.fxml"));
        }
        catch (IOException e2) {
            System.err.println("Errore nel caricamento degli FXML: " + e2.getMessage());
            e2.printStackTrace();
            return;
        }
        this.contentPane.getChildren().add(this.tilePane);
        tileMenuItem.setOnAction(e -> this.showPedinePane());
        carteMenuItem.setOnAction(e -> this.showCartePane());
        primaryStage.setTitle("Gestione Oggetti di Gioco");
        primaryStage.setScene(new Scene(root, 800.0, 600.0));
        primaryStage.show();
    }

    @FXML
    private void showPedinePane() {
        this.contentPane.getChildren().setAll((Node[])new Node[]{this.tilePane});
    }

    @FXML
    private void showCartePane() {
        this.contentPane.getChildren().setAll((Node[])new Node[]{this.cartePane});
    }

    public static void main(String[] args) {
        TileCardsJsonUtility.launch(args);
    }

    public void handleShowTileId(ActionEvent actionEvent) {
        String tileIdVal = this.tileId.getText();
        this.showTile(Integer.parseInt(tileIdVal) - 1);
    }

    public void handleNextTile(ActionEvent actionEvent) {
        String tileIdVal = this.tileId.getText();
        int currId = Integer.parseInt(tileIdVal);
        if (++currId == 157) {
            currId = 1;
        }
        this.tileId.setText(String.valueOf(currId));
        this.showTile(currId - 1);
    }

    public void handlePrevTile(ActionEvent actionEvent) {
        String tileIdVal = this.tileId.getText();
        int currId = Integer.parseInt(tileIdVal);
        if (--currId == 0) {
            currId = 156;
        }
        this.tileId.setText(String.valueOf(currId));
        this.showTile(currId - 1);
    }

    public void handleAddTileToList(ActionEvent actionEvent) {
        ArrayList<Connector> connectionsapp = new ArrayList<Connector>();
        String componentString = (String)this.tileComponentType.getValue();
        String tileIdVal = this.tileId.getText();
        System.out.println("Valore ComboBox: " + componentString);
        System.out.println("Valore TextField: " + tileIdVal);
        try {
            connectionsapp.add(Connector.fromString((String)this.comboBoxTopConn.getValue()));
            connectionsapp.add(Connector.fromString((String)this.comboBoxRConn.getValue()));
            connectionsapp.add(Connector.fromString((String)this.comboBoxBotConn.getValue()));
            connectionsapp.add(Connector.fromString((String)this.comboBoxLConn.getValue()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("connectors: " + String.valueOf(connectionsapp));
        Tile tile = new Tile(Integer.parseInt(tileIdVal), 0, connectionsapp, switch ((String)this.tileComponentType.getValue()) {
            case "BatterySlot" -> new BatterySlot(Integer.parseInt(this.extraVal.getText()));
            case "Cannon" -> new Cannon(Float.valueOf(1.0f));
            case "CentralHousingUnit" -> new CentralHousingUnit(Color.fromString((String)this.centralHousingUnitColor.getValue()));
            case "DoubleCannon" -> new DoubleCannon(false, Float.valueOf(2.0f));
            case "DoubleEngine" -> new DoubleEngine(false, 2);
            case "Engine" -> new Engine(1);
            case "GenericCargoHolds" -> new GenericCargoHolds(this.specialCargo.isSelected(), Integer.parseInt(this.extraVal.getText()));
            case "PurpleLifeSupportSystem" -> new LifeSupportSystem(AlienColor.PURPLE);
            case "BrownLifeSupportSystem" -> new LifeSupportSystem(AlienColor.BROWN);
            case "ModularHousingUnit" -> new ModularHousingUnit();
            case "Shield" -> new Shield(false);
            default -> new Component(true);
        });
        this.tiles.set(Integer.parseInt(tileIdVal) - 1, tile);
        tile.testPrint();
        System.out.println("tiles: " + String.valueOf(this.tiles));
        Object e = new ActionEvent();
        this.handleSaveTileList((ActionEvent)e);
        this.handleLoadTileList((ActionEvent)e);
    }

    @FXML
    private void handleLoadTileImage() {
        String tileIdVal = this.tileId.getText();
        if (tileIdVal != null && !tileIdVal.equals("")) {
            String imagePath = "galaxy_trucker_imgs/tiles/GT-new_tiles_16_for web".concat(tileIdVal).concat(".jpg");
            this.tileImage = new Image(this.getClass().getResourceAsStream(imagePath));
            this.tileImageView.setImage(this.tileImage);
        }
    }

    private void showTile(int id) {
        this.extraVal.setText("n");
        this.centralHousingUnitColor.setValue(Color.EMPTY.getColorString());
        this.specialCargo.setSelected(false);
        this.tileComponentType.setValue(this.tiles.get(id).getMyComponent().accept(this.componentNameVisitor));
        this.comboBoxTopConn.setValue(this.tiles.get(id).getSides().get(0).getConnectorString());
        this.comboBoxRConn.setValue(this.tiles.get(id).getSides().get(1).getConnectorString());
        this.comboBoxBotConn.setValue(this.tiles.get(id).getSides().get(2).getConnectorString());
        this.comboBoxLConn.setValue(this.tiles.get(id).getSides().get(3).getConnectorString());
        this.handleLoadTileImage();
        switch (this.tiles.get(id).getMyComponent().accept(this.componentNameVisitor)) {
            case "BatterySlot": {
                this.extraVal.setText(String.valueOf(((BatterySlot)this.tiles.get(id).getMyComponent()).getBatteriesLeft()));
                break;
            }
            case "CentralHousingUnit": {
                this.centralHousingUnitColor.setValue(((CentralHousingUnit)this.tiles.get(id).getMyComponent()).getColor().getColorString());
                break;
            }
            case "GenericCargoHolds": {
                this.extraVal.setText(String.valueOf(((GenericCargoHolds)this.tiles.get(id).getMyComponent()).getnMaxContainers()));
                this.specialCargo.setSelected(((GenericCargoHolds)this.tiles.get(id).getMyComponent()).isSpecial());
            }
        }
    }

    public void handleSaveTileList(ActionEvent actionEvent) {
        try {
            FileOutputStream fos = new FileOutputStream("src/main/resources/it/polimi/ingsw/galaxytrucker/tiledata.json");
            String json = this.mapper.writeValueAsString(this.tiles);
            fos.write(json.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handleLoadTileList(ActionEvent actionEvent) {
        try {
            FileInputStream fis = new FileInputStream("src/main/resources/it/polimi/ingsw/galaxytrucker/tiledata.json");
            this.tiles = this.mapper.readValue((InputStream)fis, new TypeReference<ArrayList<Tile>>(this){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handleJsonCiascuna(ActionEvent actionEvent) {
        Projectile EsProiettile = new Projectile(ProjectileType.Meteor, ProjectileDirection.UP, ProjectileSize.Big);
        ArrayList<Projectile> EsempioProj = new ArrayList<Projectile>();
        EsempioProj.add(EsProiettile);
        EsempioProj.add(EsProiettile);
        Good EsGood = new Good(Color.BLUE);
        ArrayList<Good> EsGoods = new ArrayList<Good>();
        EsGoods.add(EsGood);
        EsGoods.add(EsGood);
        Planet EsPianeta = new Planet(false, EsGoods);
        ArrayList<Planet> EsPlanets = new ArrayList<Planet>();
        EsPlanets.add(EsPianeta);
        EsPlanets.add(EsPianeta);
        this.cards.add(new AbandonedShip(1, 1, 1, "Nave abbandonata", false, 1, 1, false));
        this.cards.add(new AbandonedStation(1, 1, 2, "Stazione abbandonata", false, EsGoods, 8, false));
        this.cards.add(new CombatZone(1, 1, 2, "Zona Guerra", false, 2, 2, EsempioProj, true));
        this.cards.add(new Epidemic(2, 1, 2, "Epidemia", true, true));
        this.cards.add(new MeteorSwarm(1, 1, 1, "Meteoriti", false, EsempioProj, true));
        this.cards.add(new OpenSpace(1, 1, 1, "Spazio aperto", false, true));
        this.cards.add(new Pirates(1, 1, 1, "Pirati", false, 1, EsempioProj, 2, false));
        this.cards.add(new Planets(1, 1, 1, "Pianeti", false, EsPlanets, false));
        this.cards.add(new Slavers(2, 1, 1, "Schiavisti", false, 1, 1, 1, false));
        this.cards.add(new Smugglers(1, 1, 1, "Contrabbandieri", false, 2, 2, EsGoods, false));
        this.cards.add(new Stardust(1, 1, 1, "Polvere di stelle", false, true));
        ActionEvent e = new ActionEvent();
        this.handleSaveCardList(e);
        this.handleLoadCardList(e);
    }

    public void handleShowCardId(ActionEvent actionEvent) {
    }

    public void handleNextCard(ActionEvent actionEvent) {
    }

    public void handlePrevCard(ActionEvent actionEvent) {
    }

    public void handleAddCardToList(ActionEvent actionEvent) {
    }

    @FXML
    private void handleLoadFront() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("Immagini", "*.png", "*.jpg", "*.jpeg"));
        File file = fileChooser.showOpenDialog(null);
        if (file != null) {
            this.immagineFronte = file;
            this.imageViewFronte.setImage(new Image(file.toURI().toString()));
        }
    }

    @FXML
    private void handleLoadBack() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add(new FileChooser.ExtensionFilter("Immagini", "*.png", "*.jpg", "*.jpeg"));
        File file = fileChooser.showOpenDialog(null);
        if (file != null) {
            this.immagineRetro = file;
            this.imageViewRetro.setImage(new Image(file.toURI().toString()));
        }
    }

    public void handleSaveCardList(ActionEvent actionEvent) {
        try {
            FileOutputStream fos = new FileOutputStream("src/main/resources/it/polimi/ingsw/galaxytrucker/cardsdata.json");
            String json = this.mapper.writerFor(new TypeReference<ArrayList<AdventureCard>>(this){}).writeValueAsString(this.cards);
            fos.write(json.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handleLoadCardList(ActionEvent actionEvent) {
        try {
            FileInputStream fis = new FileInputStream("src/main/resources/it/polimi/ingsw/galaxytrucker/cardsdata.json");
            this.cards = this.mapper.readValue((InputStream)fis, new TypeReference<ArrayList<AdventureCard>>(this){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void showCard(int id) {
    }
}

